(function () {
    'use strict';
    
    var i,
        objectId                      = 0,
        $cablingObjectBrowser         = $('cabling_object_browser__HIDDEN'),
        $selectedObjectId             = $('selectedObjectId'),
        selectedObjectId              = 0,
        selectedObjectData            = {},
        $content                      = $('content'),
        $contentWrapper               = $('contentWrapper'),
        $visualizationTop             = $('cabling-visualization-top'),
        $visualizationTopConnectors   = $('cabling-visualization-connector-control'),
        $visualizationLeft            = $('cabling-visualization-left'),
        $visualizationLeftHeader      = $('cabling-visualization-left-header'),
        $visualizationLeftContent     = $('cabling-visualization-left-content'),
        $visualizationLeftFunctions   = $('cabling-visualization-left-functions'),
        $visualizationLeftLegend      = $('cabling-visualization-left-legend'),
        // Top buttons.
        $checkboxDisplayWiring        = $('cabling_display_wiring'),
        $checkboxDisplayOnlyConnected = $('cabling_display_only_connected'),
        $checkboxDisplayCableNames    = $('cabling_display_cable_names'),
        $checkboxEditConnectorTypes   = $('cabling_edit_connector_types'),
        // Canvas and overlay
        $canvas                       = $('cabling-visualization-canvas'),
        $overlay                      = $('cabling-visualization-overlay'),
        // Cabling instance and data.
        cabling,
        connectorPopup,
        objectTypeData                = JSON.parse('[{$objectTypeData|json_encode|escape:"javascript"}]'),
        connectorTypeData             = JSON.parse('[{$connectorTypes|json_encode|escape:"javascript"}]'),
        authEdit                      = !!parseInt('[{$authEdit}]'),
        $menuItems                    = $('mainMenu').select('li');
    
    if ($cablingObjectBrowser) {
        objectId = ($cablingObjectBrowser.getValue() || 0);
    }
    
    if ($selectedObjectId) {
        $selectedObjectId.setValue(selectedObjectId);
    }
    
    if ($visualizationTop) {
        // We need to listen to "window resizing" and dragging the navbar.
        Event.observe(window, 'resize', responsive_options);
        idoit.callbackManager
             .registerCallback('idoit-dragbar-update', responsive_options)
             .triggerCallback('idoit-dragbar-update');
    }
    
    if ($visualizationLeftContent) {
        $visualizationLeftContent.on('load:objectInformation', function (ev) {
            $visualizationLeftContent.addClassName('opacity-50');
            
            if (selectedObjectData.hasOwnProperty(selectedObjectId)) {
                // The data is cached, simply display it.
                $visualizationLeftContent.fire('display:objectInformation', ev.memo);
            } else {
                // Load and display the data from the server.
                
                new Ajax.Request(window.www_dir + 'cabling/ajax/getObjectInformation/' + selectedObjectId, {
                    parameters: {
                        type: ev.memo.type
                    },
                    onComplete: function (xhr) {
                        var json = xhr.responseJSON;
                        
                        if (!json) {
                            idoit.Notify.error(xhr.responseText, {sticky: true});
                            return;
                        }
                        
                        if (json && !json.success) {
                            idoit.Notify.error(json.message, {sticky: true});
                            return;
                        }
                        
                        selectedObjectData[selectedObjectId] = json.data;
                        
                        $visualizationLeftContent.fire('display:objectInformation', ev.memo);
                    }
                });
            }
        });
    
        $visualizationLeftContent.on('display:objectInformation', function (ev) {
            var objectData          = selectedObjectData[selectedObjectId],
                objectType          = objectTypeData[objectData.objectTypeId] || {},
                $table              = $visualizationLeftContent.down('table'),
                $cablingPopupButton = $visualizationLeftFunctions.down('[data-action="open-cabling-browser"]'),
                memo                = ev.memo;
    
            // Set the "open object" link.
            $visualizationLeftFunctions.down('a[data-action="object-link"]').writeAttribute('href', '[{$urlBase}]?[{$smarty.const.C__CMDB__GET__OBJECT}]=' + selectedObjectId);
    
            // Set the "set as root" link.
            $visualizationLeftFunctions.down('a[data-action="set-as-root"]').writeAttribute('href', '[{$urlBase}]cabling/visualization/' + selectedObjectId);
    
            if (memo.type === 'object') {
                $cablingPopupButton
                    .removeClassName('hide')
                    .stopObserving()
                    .on('click', function () {
                        get_popup('connection', '', '80%', '90%', {params: btoa('{"objID":' + selectedObjectId + '}')}, 'popup_commentary', '770px', '350px', null, null);
                    });
            } else {
                $cablingPopupButton
                    .addClassName('hide')
                    .stopObserving();
            }
            
            // Show the object functions.
            $visualizationLeftFunctions.down('div').removeClassName('hide');
            
            // Update the object information.
            $table
                .update(new Element('tr')
                    .update(new Element('td', {className: 'vat', width: '105px'})
                        .update(new Element('img', {src: objectData.objectImage, className: 'object-image pr5'})))
                    .insert(new Element('td', {className: 'vat'})
                        .update(new Element('div', {className: 'cmdb-marker', style: 'background:' + objectType.color + ';'}))
                        .insert(new Element('strong', {className: 'obj-title'})
                            .update(objectType.title + ' &raquo; ' + objectData.objectTitle))
                        .insert(new Element('hr', {className: 'mt5 mb5'}))
                        .insert(new Element('p', {className: 'mb10'})
                            .update(new Element('div', {className: 'cmdb-marker', style: 'background:' + objectData.cmdbStatusColor + ';'}))
                            .insert(new Element('span')
                                .update(objectData.cmdbStatusTitle)))));
    
            if (objectData.hasOwnProperty('locationPath')) {
                $table
                    .insert(new Element('tr')
                        .update(new Element('td', {colspan: 2, className:'pt10'})
                            .update(new Element('strong')
                                .update('[{isys type="lang" ident="LC__CMDB__CATG__GLOBAL_LOCATION"}]'))
                            .insert(new Element('br'))
                            .insert(objectData.locationPath)));
            }
    
            if (objectData.hasOwnProperty('locationInRack')) {
                $table
                    .insert(new Element('tr')
                        .update(new Element('td', {colspan: 2, className:'pt10'})
                            .update(new Element('strong')
                                .update('[{isys type="lang" ident="LC__CMDB__CATG__LOCATION_POS"}]'))
                            .insert(new Element('br'))
                            .insert(objectData.locationInRack)));
            }
    
            if (objectData.hasOwnProperty('cableType')) {
                $table
                    .insert(new Element('tr')
                        .update(new Element('td', {colspan: 2, className:'pt10'})
                            .update(new Element('strong')
                                .update('[{isys type="lang" ident="LC__CMDB__CATS__CABLE__TYPE"}]'))
                            .insert(new Element('br'))
                            .insert(objectData.cableType)));
            }
            
            if (objectData.hasOwnProperty('cableLength')) {
                $table
                    .insert(new Element('tr')
                        .update(new Element('td', {colspan: 2, className:'pt10'})
                            .update(new Element('strong')
                                .update('[{isys type="lang" ident="LC__CMDB__CATS__CABLE__LENGTH"}]'))
                            .insert(new Element('br'))
                            .insert(objectData.cableLength)));
            }
            
            if (objectData.hasOwnProperty('cableOccupancy')) {
                $table
                    .insert(new Element('tr')
                        .update(new Element('td', {colspan: 2, className:'pt10'})
                            .update(new Element('strong')
                                .update('[{isys type="lang" ident="LC__CMDB__CATS__CABLE__OCCUPANCY"}]'))
                            .insert(new Element('br'))
                            .insert(objectData.cableOccupancy)));
            }
            
            $visualizationLeftContent.removeClassName('opacity-50').removeClassName('hide');
        });
    }
    
    // Create a "responsive_options" method to use as callback, when anything changes.
    function responsive_options()
    {
        var $svg = $canvas.down('svg');
        
        // One last thing: If changing the height of the browser window, we need to change the $visualizationLeftContent aswell.
        $visualizationLeftContent.setStyle({
            height: ($visualizationLeft.getHeight() -
                     ($visualizationLeftHeader.getHeight() + $visualizationLeftFunctions.getHeight() + $visualizationLeftLegend.getHeight())) +
                    'px'
        });
    
        if ($visualizationTop.getWidth() < 1200) {
            $visualizationTop.down('.cabling-options').addClassName('condensed')
                             .select('.fl').invoke('removeClassName', 'ml20');
            $visualizationTop.select('button span').invoke('addClassName', 'hide');
        } else if ($visualizationTop.getWidth() < 1300) {
            $visualizationTop.down('.cabling-options').removeClassName('condensed')
                             .select('.fl').invoke('addClassName', 'ml20');
            $visualizationTop.select('button span').invoke('addClassName', 'hide');
        } else {
            $visualizationTop.down('.cabling-options').removeClassName('condensed')
                             .select('.fl').invoke('addClassName', 'ml20');
            $visualizationTop.select('button span').invoke('removeClassName', 'hide');
        }
        
        // We can not use "$svg.hasClassName(...)" because Prototype 1.7 can't handle SVG elements :(
        if ($svg) {
            $svg.setAttribute('width', $canvas.getWidth());
            $svg.setAttribute('height', $canvas.getHeight());
        }
        
        if (cabling) {
            cabling.responsive();
        }
    }
    
    // Mark the "extras" menu.
    for (i in $menuItems) {
        if ($menuItems.hasOwnProperty(i)) {
            if ($menuItems[i].hasClassName('extras')) {
                $menuItems[i].addClassName('active');
            } else {
                $menuItems[i].removeClassName('active');
            }
        }
    }
    
    // Display the visualization GUI above the navbar.
    if ($contentWrapper) {
        $contentWrapper.setStyle({top: '40px'});
    }
    
    window.initializeCabling = function initializeCabling(newObjectId)
    {
        $overlay.removeClassName('hide');
        
        cabling.clearCanvas();
    
        objectId = newObjectId;
        
        if (objectId > 0) {
            $visualizationLeftFunctions.select('select,button').invoke('enable');
        } else {
            $visualizationLeftFunctions.select('select,button').invoke('disable');
        }
        
        window.pushState({}, document.title, window.www_dir + 'cabling/visualization/' + objectId);
        
        if (! objectId) {
            $overlay.addClassName('hide');
            return;
        }
        
        new Ajax.Request(window.www_dir + 'cabling/ajax/getCablingData', {
            parameters: {
                objectId:         objectId,
                hideDisconnected: $checkboxDisplayOnlyConnected.checked ? 1 : 0
            },
            onComplete: function (response) {
                var json = response.responseJSON;
                
                if (!json) {
                    idoit.Notify.error(response.responseText, {sticky: true});
                    return;
                }
                
                if (json && !json.success) {
                    idoit.Notify.error(json.message, {sticky: true});
                    return;
                }
                
                selectedObjectData[objectId] = json.data.rootObject;
                
                try {
                    cabling
                        .setOption('displayWiring', $checkboxDisplayWiring.checked)
                        .setOption('nodeMarginX', ($checkboxDisplayCableNames.checked ? 100 : 25))
                        .setOption('showCableLabels', $checkboxDisplayCableNames.checked)
                        .setData(json.data.connections)
                        .process()
                        .center();
    
                    // Simulate a click on the root element (using "Element.simulate" because of the natively unsupported SVG elements).
                    Element.simulate($canvas.down('[data-id="root"] .mouse-pointer'), 'click');
                } catch (e) {
                    idoit.Notify.error(e, {sticky: true});
                }
            }
        });
    };
    
    $checkboxDisplayWiring.on('change', function () {
        cabling
            .setOption('displayWiring', $checkboxDisplayWiring.checked)
            .process();
    });
    
    $checkboxDisplayOnlyConnected.on('change', function () {
        // Simply re-initialize the cabling ;)
        window.initializeCabling(objectId);
    });
    
    $checkboxDisplayCableNames.on('change', function () {
        cabling
            .setOption('nodeMarginX', ($checkboxDisplayCableNames.checked ? 100 : 25))
            .setOption('showCableLabels', $checkboxDisplayCableNames.checked)
            .process();
    });
    
    $checkboxEditConnectorTypes.on('change', function () {
        if ($checkboxEditConnectorTypes.checked) {
            connectorPopup.show();
        } else {
            connectorPopup.hide();
        }
    });
    
    connectorPopup = new ConnectorPopup($visualizationTopConnectors, {
        $responsiveContainer: $canvas,
        onShow:               function () {
            cabling
                .setOption('clickableConnectors', true)
                .process();
        },
        onHide:               function () {
            cabling
                .setOption('clickableConnectors', false)
                .process()
                .unselectConnectors();
        },
        onApply:              function () {
            var newConnectorType = this.$connectorTypeSelect.getValue();
            
            // Set the conenctor type data directly :)
            d3.selectAll('.connector-inner:not(.hide)').data().each(function (d) {
                d.data.connectorType = newConnectorType;
            });
            
            cabling.unselectConnectors().process();
        },
        onCancel:             function () {
            cabling.unselectConnectors();
        }
    });
    
    cabling = new Cabling($canvas, [], {
        authEdit:          authEdit,
        objectTypeData:    objectTypeData,
        connectorTypeData: connectorTypeData,
        onObjSelect:       function (d) {
            // Set the "selected object".
            selectedObjectId = d.data.objectId;
            $selectedObjectId.setValue(selectedObjectId);
            
            $visualizationLeftContent.fire('load:objectInformation', {type: 'object'});
        },
        onObjUnselect:     function () {
            // Set the "selected" object to 0.
            selectedObjectId = 0;
            $selectedObjectId.setValue(selectedObjectId);
        
            // Also hide the object functions.
            $visualizationLeftFunctions.down('div').addClassName('hide');
            $visualizationLeftContent.addClassName('hide');
        },
        onCableSelect:     function (d) {
            // Set the "selected object".
            selectedObjectId = d.source.data.cableId;
            $selectedObjectId.setValue(selectedObjectId);
    
            $visualizationLeftContent.fire('load:objectInformation', {type: 'cable'});
        },
        onConnectorSelect: function () {
            connectorPopup.setData(d3.selectAll('.connector-inner:not(.hide)').data());
        },
        onConnectorUnselect: function () {
            connectorPopup.setData([]);
        },
        onAfterProcess:    function () {
            // Once the rendering is complete we'd like to hide the "loading" overlay.
            $overlay.addClassName('hide');
        }
    });
    
    // Initialize the cabling
    initializeCabling(objectId);
})();
