<?php

/**
 * i-doit
 *
 * Cabling add-on autoloader.
 *
 * @package     Modules
 * @subpackage  Cabling
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.9.1
 */
class isys_module_cabling_autoload extends isys_module_manager_autoload
{
    /**
     * Module specific autoloader.
     *
     * @param   string $className
     *
     * @return  boolean
     */
    public static function init($className)
    {
        $addOnPath = '/src/classes/modules/cabling/';
        $classMap = [
            'isys_auth_cabling'         => 'src/Auth/isys_auth_cabling.class.php',
            'isys_popup_cabling_export' => 'src/Popup/isys_popup_cabling_export.class.php',
        ];

        if (isset($classMap[$className]) && parent::include_file($addOnPath . $classMap[$className])) {
            isys_cache::keyvalue()->ns('autoload')->set($className, $addOnPath . $classMap[$className]);

            return true;
        }

        return false;
    }
}
