<?php

namespace idoit\Module\Cabling\Controller;

use idoit\Controller\CatchallController;
use idoit\Module\Cabling\Controller\Main as ControllerBase;
use idoit\Module\Cabling\Export\CSV;
use idoit\Module\Cabling\Export\GraphML;
use idoit\Module\Cabling\Export\Main as ExportBase;
use idoit\Module\Cabling\Export\PDF;
use isys_application;
use isys_array;
use isys_register;

/**
 * Export controller
 *
 * @package     Modules
 * @subpackage  Cabling
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Export extends ControllerBase
{
    /**
     * Overwriting the "handle" method.
     *
     * @param   isys_register    $p_request
     * @param   isys_application $p_application
     *
     * @return  null
     */
    public function handle(isys_register $p_request, isys_application $p_application)
    {
        return null;
    }

    /**
     * Method for preparing the necessary GraphML export class.
     *
     * @param  isys_register      $request
     * @param  CatchallController $catchallController
     */
    public function graphml(isys_register $request, CatchallController $catchallController)
    {
        $this->exportData(new GraphML(), $request->get('GET'));
    }

    /**
     * Method for preparing the necessary CSV export class.
     *
     * @param  isys_register      $request
     * @param  CatchallController $catchallController
     */
    public function csv(isys_register $request, CatchallController $catchallController)
    {
        $this->exportData(new CSV(), $request->get('GET'));
    }

    /**
     * Method for preparing the necessary PDF export class.
     *
     * @param  isys_register      $request
     * @param  CatchallController $catchallController
     */
    public function pdf(isys_register $request, CatchallController $catchallController)
    {
        $get = $request->get('GET');

        $pdf = new PDF();
        $pdf->setConnectors(explode(',', $get->get('connectors')));

        $this->exportData($pdf, $get);
    }

    /**
     * Method for preparing the necessary HTML export class.
     *
     * @param  isys_register      $request
     * @param  CatchallController $catchallController
     */
    public function html(isys_register $request, CatchallController $catchallController)
    {
        /*
        $get = $request->get('GET');

        $html = new HTML();
        $html->setConnectors(explode(',', $get->get('connectors')));

        $this->exportData($html, $get);
        */
    }

    /**
     * @param ExportBase $exporter
     * @param isys_array $data
     */
    private function exportData(ExportBase $exporter, isys_array $data)
    {
        /*
         * @see  ID-5964  When using SSL / HTTPS it is possible that a "WARNING" gets thrown, because the image
         * URL does not certify. We simply change the error reporting so that Warnings don't trigger such errors.
         *
         * The complete error message is:
         *
         * "imagecreatefrompng(): SSL operation failed with code 1. OpenSSL Error messages error:14090086:SSL
         * routines:SSL3_GET_SERVER_CERTIFICATE:certificate verify failed in [...]" (internal TCPDF code).
         */
        error_reporting(error_reporting() & ~E_WARNING);

        $exporter
            ->setFilename('cabling-export_' . date('Y-m-d_H-i-s'))
            ->setObjectId($data->get('objectId', 0))
            ->setDisplayOnlyConnected($data->get('displayOnlyConnected', true))
            ->setDisplayCableNames($data->get('displayCableNames', true))
            ->prepare()
            ->export()
            ->send();

        die;
    }
}
