<?php

namespace idoit\Module\Cabling\Controller;

use idoit\Controller\Base as BaseController;
use idoit\Module\Cabling\Model\Dao;
use idoit\Tree\Node;
use isys_application as Application;
use isys_component_template_navbar as Navbar;
use isys_component_tree as Tree;
use isys_controller as ControllerInterface;
use isys_module as Module;
use isys_register as Register;

/**
 * Main controller
 *
 * @package     Modules
 * @subpackage  Cabling
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Main extends BaseController implements ControllerInterface
{
    /**
     * @var Module
     */
    protected $module;

    /**
     * Default request handler, gets called in every "/cabling" request.
     *
     * @param   Register    $request
     * @param   Application $application
     *
     * @return  \idoit\View\Renderable|void
     */
    public function handle(Register $request, Application $application)
    {
        header('Location: ' . Application::instance()->www_path . 'cabling/visualization');

        Navbar::getInstance()->hide_all_buttons();
    }

    /**
     * @param   Application $application
     *
     * @return  \idoit\Module\Cabling\Model\Dao
     */
    public function dao(Application $application)
    {
        return Dao::instance($application->container->get('database'));
    }

    /**
     * Build the left tree.
     *
     * @param   Register    $request
     * @param   Application $application
     * @param   Tree        $tree
     *
     * @return  \isys_tree_node
     */
    public function tree(Register $request, Application $application, Tree $tree)
    {
        // Initialize tree nodes.
        return new Node(
            $this->container->get('language')->get('LC__MODULE__CABLING'),
            '',
            $request->get('BASE') . 'images/axialis/development/threads.svg'
        );
    }

    /**
     * Constructor method.
     *
     * @param  Module $module
     */
    public function __construct(Module $module)
    {
        $this->module = $module;
    }
}
