<?php

namespace idoit\Module\Cabling\Controller;

use idoit\Controller\CatchallController;
use isys_application;
use isys_register;

/**
 * Visualization controller
 *
 * @package     Modules
 * @subpackage  Cabling
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Visualization extends Main
{
    /**
     * Default handler for displaying the visualization GUI.
     *
     * @param   isys_register    $request
     * @param   isys_application $app
     *
     * @return  \idoit\Module\Cabling\View\Visualization
     */
    public function handle(isys_register $request, isys_application $app)
    {
        return new \idoit\Module\Cabling\View\Visualization($request);
    }

    /**
     * Method for displaying a image from the "images" category.
     *
     * @param  \isys_register    $request
     */
    public function backgroundImage(\isys_register $request)
    {
        echo (new \isys_cmdb_dao_category_g_images($this->container->get('database')))->load_image((int) $request->id);

        die;
    }
}
