<?php

namespace idoit\Module\Cabling\Model;

use idoit\Model\Dao\Base;

/**
 * Default DAO model.
 *
 * @package     Modules
 * @subpackage  Cabling
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Dao extends Base
{
    /**
     * Method for retrieving all necessary object type data.
     *
     * @return  \isys_component_dao_result
     * @throws  \Exception
     * @throws  \isys_exception_database
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function getObjectTypes()
    {
        return $this->retrieve(
            'SELECT isys_obj_type__id, isys_obj_type__title, isys_obj_type__icon, isys_obj_type__color
			FROM isys_obj_type
			WHERE isys_obj_type__status = ' . $this->convert_sql_int(C__RECORD_STATUS__NORMAL) . ';'
        );
    }

    /**
     * @return  array
     */
    public function getConnectionTypes()
    {
        $return   = [];
        $conTypes = \isys_cmdb_dao_cable_connection::instance($this->get_database_component())
            ->get_connection_types();

        while ($row = $conTypes->get_row())
        {
            $return[$row['isys_connection_type__id']] = [
                'title' => _L($row['isys_connection_type__title']),
                'color' => \isys_helper_color::pastel_color_from_string($row['isys_connection_type__const'])
            ];
        }

        return $return;
    }
}