[{isys_group name="tom.popup.cabling"}]
    <div id="cabling-export-popup">
        <div class="popup-header-ng">
            <h1>[{isys type="lang" ident="LC__MODULE__CABLING__VIS__EXPORT_TITLE"}] "[{$objectTitle}]"</h1>
            <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
                <img class="fr mouse-pointer" alt="close" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
            </button>
        </div>

        [{if !$objectSelected}]
        <div class="p5 m5 box-yellow">
            <img src="[{$dir_images}]axialis/basic/warning.svg" class="mr5 vam"/>
            <span class="vam">[{isys type="lang" ident="LC__MODULE__CABLING__VIS__EXPORT__NO_OBJECT_SELECTED"}]</span>
        </div>
        [{/if}]

        <div class="popup-content">
            <h4 class="border gradient p5">[{isys type="lang" ident="LC__MODULE__CABLING__VIS__EXPORT_TYPE"}]</h4>

            <label class="m5">
                <input type="radio" name="cabling-export-popup-export-type" class="mr5" value="pdf"/>
                <span>[{isys type="lang" ident="LC__MODULE__CABLING__VIS__EXPORT_TYPE__PDF"}]</span>
            </label>

            <label class="ml5">
                <input type="radio" name="cabling-export-popup-export-type" class="mr5" value="png-full"/>
                <span>[{isys type="lang" ident="LC__VISUALIZATION_EXPORT__TYPE__PNG_FULL"}]</span>
            </label>

            <label class="m5">
                <input type="radio" name="cabling-export-popup-export-type" class="mr5" value="png"/>
                <span>[{isys type="lang" ident="LC__MODULE__CABLING__VIS__EXPORT_TYPE__PNG"}]</span>
            </label>


            <label class="mt5 ml5">
                <input type="radio" name="cabling-export-popup-export-type" class="mr5" value="svg-full"/>
                <span>[{isys type="lang" ident="LC__VISUALIZATION_EXPORT__TYPE__SVG_FULL"}]</span>
            </label>

            <label class="m5">
                <input type="radio" name="cabling-export-popup-export-type" class="mr5" value="svg"/>
                <span>[{isys type="lang" ident="LC__MODULE__CABLING__VIS__EXPORT_TYPE__SVG"}]</span>
            </label>

            <label class="m5">
                <input type="radio" name="cabling-export-popup-export-type" class="mr5" value="graphml"/>
                <span>[{isys type="lang" ident="LC__MODULE__CABLING__VIS__EXPORT_TYPE__GRAPHML"}]</span>
            </label>

            <h4 class="border gradient p5">[{isys type="lang" ident="LC__MODULE__CABLING__VIS__EXPORT_CONNECTORS"}]</h4>
            <div id="cabling-export-popup-options" class="opacity-30">
                <div>
                    <!-- Overlay to prevent clicking -->
                </div>
                <table class="listing two-col">
                    <thead>
                    <tr>
                        <td class="pl20">
                            <label><input type="checkbox" id="selectedInputsAll"
                                          class="mr10"/>[{isys type="lang" ident="LC__UNIVERSAL__ALL"}]</label>
                        </td>
                        <td class="pr20">
                            <label>[{isys type="lang" ident="LC__UNIVERSAL__ALL"}]<input type="checkbox"
                                                                                         id="selectedOutputsAll"
                                                                                         class="ml10"/></label>
                        </td>
                    </tr>
                    </thead>
                    <tbody>
                    [{foreach $inputConnectors as $conn}]
                        <tr>
                            <td class="pl20">
                                <label><input type="checkbox" name="selectedInputs[]" value="[{$conn.id}]"
                                              class="mr10 conn"/>[{$conn.title}]</label>
                            </td>
                            <td class="pr20">
                                [{foreach $conn.siblings as $sibling}]
                                <label>[{$sibling.title}] <input type="checkbox" name="selectedOutputs[]"
                                                                 value="[{$sibling.id}]" class="ml10 conn"/></label>
                                [{/foreach}]
                            </td>
                        </tr>
                        [{/foreach}]
                    [{foreach $outputConnectors as $conn}]
                        <tr>
                            <td class="pl20">

                            </td>
                            <td class="pr20">
                                <label>[{$conn.title}] <input type="checkbox" name="selectedOutputs[]"
                                                              value="[{$conn.id}]" class="ml10 conn"/></label>
                            </td>
                        </tr>
                        [{/foreach}]
                    </tbody>
                </table>
            </div>

        </div>

        <div class="popup-footer-ng">
            <button type="button" class="btn mr5" id="cabling-export-popup-save">
                <img src="[{$dir_images}]axialis/basic/symbol-ok.svg" /><span>[{isys type="lang" ident="LC__MODULE__CABLING__VIS__EXPORT"}]</span>
            </button>

            <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" /><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL_CLOSE"}]</span>
            </button>
        </div>
    </div>

    <script type="text/javascript">
        (function () {
            'use strict';

            var $popup = $('cabling-export-popup'),
                $connectionOptions = $('cabling-export-popup-options'),
                $accept_button = $('cabling-export-popup-save'),
                $selectedInputsAll = $('selectedInputsAll'),
                $selectedOutputsAll = $('selectedOutputsAll'),
                $canvas = $('cabling-visualization-canvas');

            $popup.select('.popup-closer').invoke('on', 'click', function () {
                popup_close();
            });

            $popup.on('change', '[name="cabling-export-popup-export-type"]', function (ev) {
                var value = ev.findElement('input').getValue();

                if (value === 'pdf' || value === 'html') {
                    $connectionOptions.removeClassName('opacity-30').down('div').addClassName('hide');
                } else {
                    $connectionOptions.addClassName('opacity-30').down('div').removeClassName('hide');
                }
            });

            $accept_button.on('click', function () {
                var $checkedCheckbox = $popup.down('[name="cabling-export-popup-export-type"]:checked'),
                    date = new Date(),
                    fileName = 'cabling-export_' + date.getFullYear() + '-' + ('0' + (1 + date.getMonth())).substr(-2, 2) + '-' + ('0' + date.getDate()).substr(-2, 2),
                    options = {},
                    $svg = $('cabling-visualization-canvas').down('svg'),
                    export_type;

                if (!$checkedCheckbox) {
                    idoit.Notify.info(' ### Bitte wählen Sie zunächst einen Export Typen aus', {life: 5});

                    return;
                }

                export_type = $checkedCheckbox.getValue();

                switch (export_type) {
                    default:
                    case 'svg-full':
                        prepareFullSvg().saveToSvg({filename: fileName});
                        break;
                    case 'png-full':
                        prepareFullSvg().saveToPng({filename: fileName, scale: 2});
                        break;
                    case 'svg':
                        $svg
                            .saveToSvg({filename: fileName});
                        break;
                    case 'png':
                        $svg
                            .saveToPng({
                                filename: fileName,
                                scale: 2
                            });
                        break;
                    case 'pdf':
                    case 'html':
                        options.connectors = $connectionOptions.select('input.conn:checked').invoke('getValue');

                        if (options.connectors.length === 0) {
                            options.connectors = $connectionOptions.select('input.conn').invoke('readAttribute', 'value');
                        }

                        options.connectors = options.connectors.join();
                    case 'graphml':
                    case 'csv':
                        options.objectId = $F('selectedObjectId');
                        options.displayOnlyConnected = ($('cabling_display_only_connected').checked ? 1 : 0);
                        options.displayCableNames = ($('cabling_display_cable_names').checked ? 1 : 0);

                        document.location.href = '[{$exportURL}]' + export_type + '?' + Object.toQueryString(options);
                        break;
                }
            });

            $selectedInputsAll.on('change', function () {
                $connectionOptions.select('input[name="selectedInputs[]"]').invoke('setValue', ($selectedInputsAll.checked ? 1 : 0));
            });

            $selectedOutputsAll.on('change', function () {
                $connectionOptions.select('input[name="selectedOutputs[]"]').invoke('setValue', ($selectedOutputsAll.checked ? 1 : 0));
            });

            [{if !$objectSelected}]
            $accept_button.disable();
            $popup.select('[name="cabling-export-popup-export-type"]').invoke('disable');
            [{/if}]

            /**
             * This function will create a element which contains a 1:1 copy of the canvas' SVG.
             * Only difference is, that this element will be sized to display its content in full
             * and update the `transform="translate(...)"` values accordingly.
             *
             * @returns {*}
             */
            function prepareFullSvg() {
                var $nodes = $canvas.select('.node'),
                    $printView = new Element('div'),
                    match,
                    i,
                    matchRegExp = /translate\(([-\d\.]*),\s*([-\d\.]*)\)/,
                    boundingBox = {width: 200, height: 50},
                    minX = 0,
                    minY = 0,
                    maxX = 0,
                    maxY = 0;

                if ($nodes[0]) {
                    try {
                        boundingBox = $nodes[0].getBBox();
                    } catch (e) {
                        try {
                            // Using `getBoundingClientRect` as fallback (for example for IE 11).
                            boundingBox = $nodes[0].getBoundingClientRect();
                        } catch (e) {
                            // Do nothing, use the defaults.
                        }
                    }
                }

                for (i in $nodes) {
                    if (!$nodes.hasOwnProperty(i)) {
                        continue;
                    }

                    try {
                        match = Element.readAttribute($nodes[i], 'transform').match(matchRegExp);

                        // Get minimum X and Y coordinates.
                        minX = Math.min(minX, parseInt(match[1]));
                        minY = Math.min(minY, parseInt(match[2]));

                        // Get maximum X and Y coordinates.
                        maxX = Math.max(maxX, parseInt(match[1]));
                        maxY = Math.max(maxY, parseInt(match[2]));
                    } catch (e) {
                        // Do nothing
                    }
                }

                // Add the node width and height to the dimensions (will also create a nice margin).
                minX = Math.abs(minX) + (boundingBox.width * 1.5);
                minY = Math.abs(minY) + boundingBox.height;
                maxX += (boundingBox.width * 1.5);
                maxY += boundingBox.height;

                // Pass the element to D3 since it can handle SVG elements.
                $printView = d3.select($printView.update($canvas.innerHTML));

                // Select the SVG, alter some attributes (+ some attributes of the direct <g> descendants) and return the node.
                return $printView.select('svg')
                    .attr('viewBox', '0 0 ' + (minX + maxX) + ' ' + (minY + maxY))
                    .attr('width', (minX + maxX))
                    .attr('height', (minY + maxY))
                    .call(function (svg) {
                        svg.selectAll('svg > g').attr('transform', 'translate(' + minX + ',' + minY + ') scale(1)');
                    })
                    .node();
            }

        })();
    </script>
    <style>
        #cabling-export-popup {
            box-sizing: border-box;
            position: relative;
            height: 100%;
        }

        .popup-content label {
            display: block;
        }

        #cabling-export-popup-options {
            position: relative;
            height: 197px;
            overflow: hidden;
            overflow-y: auto;
        }

        #cabling-export-popup-options div {
            position: absolute;
            top: 0;
            right: 0;
            bottom: 0;
            left: 0;
        }

        #cabling-export-popup-options .pr20 label {
            text-align: right;
        }
    </style>
    [{/isys_group}]