<?php

/**
 * i-doit
 *
 * Auth: Class for i-doit authorization rules.
 *
 * @package     Modules
 * @subpackage  Cabling
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_auth_cabling extends isys_auth implements isys_auth_interface
{
    /**
     * Container for singleton instance
     *
     * @var  isys_auth_cabling
     */
    private static $m_instance;

    /**
     * Method for returning the available auth-methods. This will be used for the GUI.
     *
     * @return  array
     */
    public function get_auth_methods()
    {
        return [
            'visualization' => [
                'title'  => 'LC__MODULE__CABLING__AUTH__VISUALIZATION',
                'type'   => 'boolean',
                'rights' => [isys_auth::VIEW, isys_auth::EDIT]
            ]
        ];
    }

    /**
     * Get ID of related module.
     *
     * @return  integer
     */
    public function get_module_id()
    {
        return C__MODULE__CABLING;
    }

    /**
     * Get title of related module.
     *
     * @return  string
     */
    public function get_module_title()
    {
        return 'LC__MODULE__CABLING';
    }

    /**
     * Retrieve singleton instance of authorization class.
     *
     * @return isys_auth_cabling
     */
    public static function instance()
    {
        // If the DAO has not been loaded yet, we initialize it now.
        if (self::$m_dao === null) {
            self::$m_dao = new isys_auth_dao(isys_application::instance()->container->get('database'));
        }

        if (self::$m_instance === null) {
            self::$m_instance = new self;
        }

        return self::$m_instance;
    }
}
