<?php

namespace idoit\Module\Cabling\Export;

/**
 * Abstract main export class
 *
 * @package     Modules
 * @subpackage  Cabling
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
abstract class Main
{
    /**
     * @var int
     */
    protected $objectId = 0;

    /**
     * @var string
     */
    protected $filename = '';

    /**
     * @var bool
     */
    protected $displayOnlyConnected = true;

    /**
     * @var bool
     */
    protected $displayCableNames = true;

    /**
     * @param $objectId
     *
     * @return $this
     */
    public function setObjectId($objectId)
    {
        $this->objectId = $objectId;

        return $this;
    }

    /**
     * @param string $filename
     *
     * @return $this
     */
    public function setFilename($filename)
    {
        $this->filename = $filename;

        return $this;
    }

    /**
     * @param $value
     *
     * @return $this
     */
    public function setDisplayOnlyConnected($value)
    {
        $this->displayOnlyConnected = (bool) $value;

        return $this;
    }

    /**
     * @param $value
     *
     * @return $this
     */
    public function setDisplayCableNames($value)
    {
        $this->displayCableNames = (bool) $value;

        return $this;
    }

    /**
     * @return $this
     */
    abstract public function prepare();

    /**
     * @return $this
     */
    abstract public function export();

    /**
     * @return void
     */
    abstract public function send();
}