<?php

namespace idoit\Module\Cabling\Model;

use idoit\Model\Dao\Base;
use isys_application;
use isys_component_dao_result;

/**
 * Default DAO model.
 *
 * @package     Modules
 * @subpackage  Cabling
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class Dao extends Base
{
    /**
     * Method for retrieving all necessary object type data.
     *
     * @return isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function getObjectTypes(): isys_component_dao_result
    {
        $statusNormal = $this->convert_sql_int(C__RECORD_STATUS__NORMAL);
        $sql = "SELECT isys_obj_type__id, isys_obj_type__title, isys_obj_type__color
			FROM isys_obj_type
			WHERE isys_obj_type__status = {$statusNormal};";

        return $this->retrieve($sql);
    }

    /**
     * @return array
     * @throws \isys_exception_database
     */
    public function getConnectionTypes(): array
    {
        $return = [];
        $language = isys_application::instance()->container->get('language');
        $conTypes = \isys_cmdb_dao_cable_connection::instance($this->get_database_component())
            ->get_connection_types();

        while ($row = $conTypes->get_row()) {
            $return[$row['isys_connection_type__id']] = [
                'title' => $language->get($row['isys_connection_type__title']),
                'color' => \isys_helper_color::pastel_color_from_string($row['isys_connection_type__const'])
            ];
        }

        return $return;
    }
}
