<?php

/**
 * i-doit
 *
 * Cabling add-on initializer
 *
 * @package     Modules
 * @subpackage  Cabling
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

use idoit\Component\Autoloader;
use idoit\Psr4AutoloaderClass;
use Symfony\Component\Config\FileLocator;
use Symfony\Component\Routing\Loader\PhpFileLoader;

if (isys_module_manager::instance()->is_active('cabling')) {
    Psr4AutoloaderClass::factory()->addNamespace('idoit\Module\Cabling', __DIR__ . '/src/');

    Autoloader::appendClassmap(require __DIR__ . '/classmap.php');

    // Add routes.
    isys_application::instance()->container->get('routes')
        ->addCollection((new PhpFileLoader(new FileLocator(__DIR__)))->load('config/routes.php'));
}
