<?php

use idoit\AddOn\AuthableInterface;

/**
 * i-doit
 *
 * Cabling add-on class
 *
 * @package     Modules
 * @subpackage  Cabling
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.9.1
 */
class isys_module_cabling extends isys_module implements AuthableInterface
{
    // Define, if this module shall be displayed in the named menus.
    const DISPLAY_IN_MAIN_MENU   = true;
    const DISPLAY_IN_SYSTEM_MENU = false;
    const MAIN_MENU_REWRITE_LINK = true;

    /**
     * Initializes the module.
     *
     * @param   isys_module_request $p_req
     *
     * @return  isys_module_cabling
     */
    public function init(isys_module_request $p_req)
    {
        return $this;
    }

    /**
     * Get related auth class for module.
     *
     * @return isys_auth_cabling
     */
    public static function getAuth()
    {
        return isys_auth_cabling::instance();
    }
}
