<style media="all">
	h1, h2, h3, h4, h5 {
		margin: 0 0 15px 0;
	}

	p {
		color: #000;
		margin: 0;
		margin-bottom: 5px;
		padding: 0;
		line-height: 12pt;
	}

	small {
		margin-top: 5px;
		display: block;
		font-size: 7pt;
		line-height: 8pt;
	}

	a {
		text-decoration: none;
	}

	.marker {
		background-color: transparent;
		border: 1px solid #000;
		font-size: 80%;
		line-height: 80%;
	}
</style>

[{foreach $connectorPaths as $i => $connectorPath}]
	[{if count($connectorPath) > 1}]
		<h2>[{isys type="lang" ident="LC__MODULE__CABLING__PDF__CABLING_PATH"}]: [{$connectorDirection}] [{$i+1}]</h2>
		<table cellpadding="3" cellspacing="0" style="border:1px solid #000">
			<thead>
				<tr style="background-color: #ddd">
					<th style="width:25%;">Eingang</th>
					<th style="width:50%;">Objekt</th>
					<th style="width:25%;">Ausgang</th>
				</tr>
			</thead>
			<tbody>
				[{foreach $connectorPath as $j => $connector}]
					<tr style="background-color: #fff;">
						<td style="width:25%;">
							[{if $connector.in.parentId !== null}]
								[{$connector.in.title}]<br />
								<small><strong>[{isys type="lang" ident="LC__MODULE__CABLING__PDF__CONNECTOR_TYPE"}]</strong> [{$connector.in.connectorTypeTitle}]</small>
							[{/if}]
						</td>
						<td style="width:50%;">
							<strong class="marker" style="background-color: [{$connector.in.objectTypeColor}]">&nbsp;&nbsp;</strong>
							<strong><a href="[{$baseUrl}]?[{$smarty.const.C__CMDB__GET__OBJECT}]=[{$connector.in.objectId}]">[{$connector.in.objectTypeTitle}] &raquo; [{$connector.in.objectTitle}]</a></strong>

							<small>
								<br />
								<strong>[{isys type="lang" ident="LC__CMDB__CATG__GLOBAL_LOCATION"}]</strong> [{$connector.in.locationPath|default:"-"}]<br />
								<strong>[{isys type="lang" ident="LC__CMDB__CATG__LOCATION_POS"}]</strong> [{$connector.in.locationInRack|default:"-"}]
							</small>
						</td>
						<td style="width:25%;">
							[{if $connector.out}]
								[{$connector.out.title}]<br />
								<small><strong>[{isys type="lang" ident="LC__MODULE__CABLING__PDF__CONNECTOR_TYPE"}]</strong> [{$connector.out.connectorTypeTitle}]</small>
							[{else}]
								-
							[{/if}]
						</td>
					</tr>
					[{if $connector.next}]
						<tr style="background-color: #f0f0f0;">
							<td></td>
							<td>
								<strong><a href="[{$baseUrl}]?[{$smarty.const.C__CMDB__GET__OBJECT}]=[{$connector.out.connectorId}]">[{isys type="lang" ident="LC__CMDB__OBJTYPE__CABLE"}] &raquo; [{$connector.out.cableTitle}]</a></strong>

								<small>
									<br />
									<strong>[{isys type="lang" ident="LC__CMDB__CATS__CABLE__TYPE"}]</strong> [{$connector.cable.cableType|default:"-"}]<br />
									<strong>[{isys type="lang" ident="LC__CMDB__CATS__CABLE__LENGTH"}]</strong> [{$connector.cable.cableLength|default:"-"}]<br />
									<strong>[{isys type="lang" ident="LC__CMDB__CATS__CABLE__OCCUPANCY"}]</strong> [{$connector.cable.cableOccupancy|default:"-"}]
								</small>
							</td>
							<td></td>
						</tr>
					[{/if}]
				[{/foreach}]
			</tbody>
		</table>
	[{/if}]
[{/foreach}]
