<?php

/**
 * i-doit
 *
 * Cabling add-on installer class
 *
 * @package     Modules
 * @subpackage  Cabling
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.10
 */
class isys_module_cabling_install
{
    /**
     * Init method.
     *
     * @param   isys_component_database $database
     * @param   isys_component_database $databaseSystem
     * @param   integer                 $moduleId
     * @param   string                  $type
     *
     * @return  void
     */
    public static function init($database, $databaseSystem, $moduleId, $type)
    {
        if ($type !== 'install') {
            return;
        }

        $dao = isys_cmdb_dao::instance($database);

        $queries = [];
        $adminObjectId = $dao->retrieve('SELECT isys_obj__id FROM isys_obj WHERE isys_obj__const = "C__OBJ__PERSON_GROUP_ADMIN";')->get_row_value('isys_obj__id');
        $authorObjectId = $dao->retrieve('SELECT isys_obj__id FROM isys_obj WHERE isys_obj__const = "C__OBJ__PERSON_GROUP_AUTHOR";')->get_row_value('isys_obj__id');
        $editorObjectId = $dao->retrieve('SELECT isys_obj__id FROM isys_obj WHERE isys_obj__const = "C__OBJ__PERSON_GROUP_EDITOR";')->get_row_value('isys_obj__id');

        if ($adminObjectId > 0) {
            $queries[] = 'INSERT isys_auth
                SET isys_auth__isys_obj__id = ' . $dao->convert_sql_id($adminObjectId) . ',
                isys_auth__type = ' . $dao->convert_sql_int(isys_auth::VIEW + isys_auth::EDIT) . ',
                isys_auth__isys_module__id = ' . $dao->convert_sql_id($moduleId) . ',
                isys_auth__path = "VISUALIZATION",
                isys_auth__status = ' . $dao->convert_sql_int(C__RECORD_STATUS__NORMAL) . ';';
        }

        if ($authorObjectId > 0) {
            $queries[] = 'INSERT isys_auth
                SET isys_auth__isys_obj__id = ' . $dao->convert_sql_id($authorObjectId) . ',
                isys_auth__type = ' . $dao->convert_sql_int(isys_auth::VIEW + isys_auth::EDIT) . ',
                isys_auth__isys_module__id = ' . $dao->convert_sql_id($moduleId) . ',
                isys_auth__path = "VISUALIZATION",
                isys_auth__status = ' . $dao->convert_sql_int(C__RECORD_STATUS__NORMAL) . ';';
        }

        if ($editorObjectId > 0) {
            $queries[] = 'INSERT isys_auth
                SET isys_auth__isys_obj__id = ' . $dao->convert_sql_id($editorObjectId) . ',
                isys_auth__type = ' . $dao->convert_sql_int(isys_auth::VIEW + isys_auth::EDIT) . ',
                isys_auth__isys_module__id = ' . $dao->convert_sql_id($moduleId) . ',
                isys_auth__path = "VISUALIZATION",
                isys_auth__status = ' . $dao->convert_sql_int(C__RECORD_STATUS__NORMAL) . ';';
        }

        if (count($queries)) {
            foreach ($queries as $l_sql) {
                $dao->update($l_sql);
            }

            // Apply the changes.
            $dao->apply_update();
        }
    }
}
