<?php

namespace idoit\Module\Cabling\Controller;

use Exception;
use isys_application;
use isys_format_json;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;

/**
 * Visualization controller
 *
 * @package     Modules
 * @subpackage  Cabling
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class PreferencesController
{
    /**
     * @param Request $request
     *
     * @return JsonResponse
     */
    public function save(Request $request)
    {
        try {
            isys_application::instance()->container->get('settingsUser')
                ->set('cabling.visualization-preferences', isys_format_json::encode([
                    'displayWiring'        => (bool)$request->request->get('displayWiring'),
                    'displayOnlyConnected' => (bool)$request->request->get('displayOnlyConnected'),
                    'displayCableNames'    => (bool)$request->request->get('displayCableNames')
                ]));

            return new JsonResponse([
                'success' => true,
                'data'    => null,
                'message' => ''
            ]);
        } catch (Exception $e) {
            return new JsonResponse([
                'success' => false,
                'data'    => null,
                'message' => $e->getMessage()
            ]);
        }
    }
}
