<?php

namespace idoit\Module\Cabling\Export;

use idoit\Module\Cabling\Model\Cabling;
use idoit\Module\Cabling\PDF\Visitor;
use isys_application as App;
use isys_tree as Tree;
use isys_tree_node as TreeNode;

/**
 * GraphML export class.
 *
 * @package     Modules
 * @subpackage  Cabling
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class HTML extends Main
{
    /**
     * @var \isys_component_template
     */
    private $smarty;

    /**
     * @var array
     */
    private $connectors = [];

    /**
     * @var array
     */
    private $data = [];

    /**
     * @param array $connectors
     *
     * @return $this
     */
    public function setConnectors(array $connectors = [])
    {
        $this->connectors = $connectors;

        return $this;
    }

    /**
     * @return $this
     */
    public function prepare()
    {
        $this->smarty = \isys_application::instance()->container->get('template');

        return $this;
    }

    /**
     * @return $this
     */
    public function export()
    {
        // First we load the necessary data.
        $cablingDao = Cabling::instance(App::instance()->container->get('database'));

        // Next we are going to print some information about our root object.
        $this->pdf->printRootInformation($cablingDao->getSourceObject($this->objectId));

        // Then we'll load the selected connectors and all their children.
        $this->data = $cablingDao->resolve($this->objectId, true, $this->connectors);

        // Finally we process the left and right data.
        $this
            ->processData('left')
            ->processData('right');

        return $this;
    }

    /**
     * @param $direction
     *
     * @return $this
     */
    private function processData($direction)
    {
        if (!count($this->data[$direction]))
        {
            return $this;
        }

        $nodes   = [];
        $visitor = new Visitor([/* Options */]);
        $tree    = new Tree();

        // Create "tree nodes" of all collected connections.
        foreach ($this->data[$direction] as $cablingDatum)
        {
            $nodes[$cablingDatum['id']] = new TreeNode($cablingDatum);
        }

        // Create a tree with our root node.
        $tree->add($nodes['root']);

        // Create a tree structure from the flat "parent / child" array.
        foreach ($nodes as $processedNode)
        {
            if (isset($nodes[$processedNode->get_data('parentId')]))
            {
                $nodes[$processedNode->get_data('parentId')]->add($processedNode);
            }
        }

        // Call the visitor on all our nodes. This will create unique paths for every "end" object.
        foreach ($tree->all_nodes() as $node)
        {
            $node->accept($visitor);
        }

        // Pass our unique paths to the PDF worker.
        $this->pdf->printConnectorPaths($direction, $visitor->getUniquePaths());

        return $this;
    }

    /**
     *
     */
    public function send()
    {
        ob_clean();

        $this->pdf->output($this->filename . '.pdf', 'd');
    }
}
