<?php

namespace idoit\Module\Cabling\PDF;

/**
 * i-doit
 *
 * Tree visitor class.
 *
 * @package     modules
 * @subpackage  analytics
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.9
 */
class Visitor implements \isys_tree_visitor_interface
{
    /**
     * @var  array
     */
    private $filter = [];

    /**
     * @var array
     */
    private $uniquePaths = [];

    /**
     * @param \isys_tree_node $node
     *
     * @return array
     */
    private function getAllNodeParents(\isys_tree_node $node)
    {
        $data = (array) $node->get_data();

        unset($data['children']);

        // Save the "start" object data to the current path (without children).
        $return = [$data];

        while ($parent = $node->get_parent())
        {
            $data = (array) $parent->get_data();

            unset($data['children']);

            // Save the objects data to the current path (without children).
            $return[] = $data;

            $node = $parent;
        }

        return $return;
    }

    /**
     * @param \isys_tree $node
     *
     * @return mixed
     */
    public function visit(\isys_tree $node)
    {
        if ($node instanceof \isys_tree_node && !$node->has_children())
        {
            $this->uniquePaths[(string) $node->get_data('id')] = array_reverse($this->getAllNodeParents($node));
        }

        return true;
    }

    /**
     * @return array
     */
    public function getUniquePaths()
    {
        return array_values($this->uniquePaths);
    }

    /**
     * Construct visitor with special filter.
     *
     * @param  array $filter
     */
    public function __construct(array $filter)
    {
        $this->filter = $filter;
    }
}