<?php

/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     Modules
 * @subpackage  Check_MK
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_check_mk_autoload extends isys_module_manager_autoload
{
    /**
     * Module specific autoloader.
     *
     * @param   string $className
     *
     * @return  boolean
     */
    public static function init($className)
    {
        $addOnPath = '/src/classes/modules/check_mk/';
        $classMap = [
            'isys_ajax_handler_check_mk'                => 'handler/ajax/isys_ajax_handler_check_mk.class.php',
            'isys_auth_check_mk'                        => 'auth/isys_auth_check_mk.class.php',
            'isys_check_mk_dao'                         => 'dao/isys_check_mk_dao.class.php',
            'isys_check_mk_dao_generic_tag'             => 'dao/isys_check_mk_dao_generic_tag.class.php',
            'isys_check_mk_helper'                      => 'helper/isys_check_mk_helper.class.php',
            'isys_check_mk_helper_tag'                  => 'helper/isys_check_mk_helper_tag.class.php',
            'isys_cmdb_dao_category_g_cmk'              => 'cmdb/dao/global/isys_cmdb_dao_category_g_cmk.class.php',
            'isys_cmdb_dao_category_g_cmk_host_service' => 'cmdb/dao/global/isys_cmdb_dao_category_g_cmk_host_service.class.php',
            'isys_cmdb_dao_category_g_cmk_service'      => 'cmdb/dao/global/isys_cmdb_dao_category_g_cmk_service.class.php',
            'isys_cmdb_dao_category_g_cmk_tag'          => 'cmdb/dao/global/isys_cmdb_dao_category_g_cmk_tag.class.php',
            'isys_cmdb_dao_list_catg_cmk_host_service'  => 'cmdb/dao/list/isys_cmdb_dao_list_catg_cmk_host_service.class.php',
            'isys_cmdb_dao_list_catg_cmk_service'       => 'cmdb/dao/list/isys_cmdb_dao_list_catg_cmk_service.class.php',
            'isys_cmdb_ui_category_g_cmk'               => 'cmdb/ui/global/isys_cmdb_ui_category_g_cmk.class.php',
            'isys_cmdb_ui_category_g_cmk_host_service'  => 'cmdb/ui/global/isys_cmdb_ui_category_g_cmk_host_service.class.php',
            'isys_cmdb_ui_category_g_cmk_service'       => 'cmdb/ui/global/isys_cmdb_ui_category_g_cmk_service.class.php',
            'isys_cmdb_ui_category_g_cmk_tag'           => 'cmdb/ui/global/isys_cmdb_ui_category_g_cmk_tag.class.php',
            'isys_export_helper_check_mk'               => 'export-helper/isys_export_helper_check_mk.class.php',
            'isys_global_cmk_tag_export_helper'         => 'export-helper/isys_global_cmk_tag_export_helper.class.php',
            'isys_handler_check_mk'                     => 'handler/controller/isys_handler_check_mk.class.php',
            'isys_handler_check_mk_export'              => 'handler/controller/isys_handler_check_mk_export.class.php',
        ];

        if (isset($classMap[$className]) && parent::include_file($addOnPath . $classMap[$className])) {
            isys_cache::keyvalue()->ns('autoload')->set($className, $addOnPath . $classMap[$className]);

            return true;
        }

        return false;
    }
}
