<div class="m5">
	<p class="mb5">[{isys type="lang" ident="LC__MODULE__CHECK_MK__TAG_GUI__GENERIC_DESCRIPTION" p_bHtmlEncode=false}]</p>
	<p class="mb15">[{isys type="lang" ident="LC__MODULE__CHECK_MK__TAG_GUI__GENERIC_EXAMPLE_1" p_bHtmlEncode=false}]</p>

	<p class="mb5">[{isys type="lang" ident="LC__MODULE__CHECK_MK__TAG_GUI__GENERIC_DESCRIPTION_2" p_bHtmlEncode=false}]</p>
	<p class="mb15">[{isys type="lang" ident="LC__MODULE__CHECK_MK__TAG_GUI__GENERIC_EXAMPLE_2" p_bHtmlEncode=false}]</p>
</div>

<fieldset class="overview mb20">
	<legend>[{isys type="lang" ident="LC__MODULE__CHECK_MK__TAG_GUI__GLOBAL_DEFINITION"}]</legend>

	<div class="p10">
		<table class="contentTable">
			<tr>
				<td class="key">[{isys type="f_label" ident="LC__MODULE__CHECK_MK__TAG_GUI__GENERIC_LOCATION_EXPORT" name="generic_location"}]</td>
				<td class="value">[{isys type="f_dialog" name="generic_location" p_strClass="input-mini export-generic-location" p_bDbFieldNN=true}]</td>
			</tr>
			<tr>
				<td class="key">[{isys type="f_label" ident="LC__MODULE__CHECK_MK__TAG_GUI__GENERIC_LOCATION_OBJ_TYPE" name="generic_location_obj_type"}]</td>
				<td class="value">[{isys type="f_dialog" name="generic_location_obj_type" p_strClass="input-small generic-location-object-type"}]</td>
			</tr>
		</table>

		[{isys type="f_property_selector" name="generic_tag_properties" preselection=$preselection provide=$smarty.const.C__PROPERTY__PROVIDES__REPORT p_bInfoIconSpacer=0 allowed_property_types='["dialog","dialog_plus","object_browser"]' grouping=false dynamic_properties=0}]
	</div>
</fieldset>

<fieldset class="overview p0">
	<legend>[{isys type="lang" ident="LC__MODULE__CHECK_MK__TAG_GUI__CATEGORY_DEFINITION"}]</legend>

	[{foreach $check_mk_obj_types as $obj_type_const => $obj_type}]
    <div class="m10">
        <div class="bg-neutral-200 border p5 display-flex align-items-center">
            <button type="button" class="btn btn-secondary obj-type-opener mr5" title="[{isys type="lang" ident="LC__UNIVERSAL__TOGGLE_VIEW"}]" data-tooltip="1">
                <img src="[{$dir_images}]axialis/user-interface/angle-right-small.svg" />
            </button>
            <h2 class="vam">[{$obj_type.title}]</h2>
        </div>
        <div class="border p5 hide obj-type-config" style="border-top: none;" data-obj-type-const="[{$obj_type_const}]">
            <table class="contentTable mb5">
                <tr>
                    <td class="key">[{isys type="f_label" ident="LC__MODULE__CHECK_MK__TAG_GUI__OVERWRITE_GLOBAL_DEFINITION" name="overwrite_global_$obj_type_const"}]</td>
                    <td class="value">[{isys type="f_dialog" name="overwrite_global_$obj_type_const" p_strClass="input-mini" p_bDbFieldNN=true}]</td>
                </tr>
                <tr>
                    <td class="key">[{isys type="f_label" ident="LC__MODULE__CHECK_MK__TAG_GUI__GENERIC_LOCATION_EXPORT" name="generic_location_$obj_type_const"}]</td>
                    <td class="value">[{isys type="f_dialog" name="generic_location_$obj_type_const" p_strClass="input-mini export-generic-location" p_bDbFieldNN=true}]</td>
                </tr>
                <tr>
                    <td class="key">[{isys type="f_label" ident="LC__MODULE__CHECK_MK__TAG_GUI__GENERIC_LOCATION_OBJ_TYPE" name="generic_location_obj_type_$obj_type_const"}]</td>
                    <td class="value">[{isys type="f_dialog" name="generic_location_obj_type_$obj_type_const" p_strClass="input-small generic-location-object-type"}]</td>
                </tr>
            </table>

            [{isys type="f_property_selector" name="generic_tag_properties_$obj_type_const" obj_type_id=$obj_type.id preselection=$obj_type.preselection provide=$smarty.const.C__PROPERTY__PROVIDES__REPORT p_bInfoIconSpacer=0 allowed_property_types='["dialog","dialog_plus","object_browser"]' grouping=false dynamic_properties=0}]
        </div>
    </div>
	[{/foreach}]
</fieldset>

<script type="text/javascript">
	(function () {
		"use strict";

		var $cmdbTagTab = $('check_mk-cmdb-tags');

		$cmdbTagTab.on('click', '.obj-type-opener', function (ev) {
            const $button = ev.findElement('button');
			const hidden = $button.up('.m10').down('.obj-type-config').toggleClassName('hide').hasClassName('hide');

			$button.down('img').writeAttribute('src', window.dir_images + 'axialis/user-interface/angle-' + (hidden ? 'right' : 'down') + '-small.svg')
		});

		$cmdbTagTab.select('.export-generic-location').invoke('on', 'change', function (ev) {
			var $select = ev.findElement('select'),
				$objTypeSelection = $select.up('table').down('.generic-location-object-type');

			if ($select.getValue() == '0') {
				$objTypeSelection.disable();
			} else {
				$objTypeSelection.enable();
			}
		});

		$cmdbTagTab.select('.export-generic-location').invoke('simulate', 'change');
	}());
</script>
