<?php

/**
 * i-doit
 *
 * DAO: list DAO for Check_MK.
 *
 * @package     Modules
 * @subpackage  Check_MK
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.0
 */
class isys_cmdb_dao_list_catg_cmk_service extends isys_component_dao_category_table_list implements isys_cmdb_dao_list_interface
{
    /**
     * Return constant of category.
     *
     * @return  integer
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function get_category()
    {
        return C__CATG__CMK_SERVICE;
    }

    /**
     * Return constant of category type.
     *
     * @return  integer
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function get_category_type()
    {
        return C__CMDB__CATEGORY__TYPE_GLOBAL;
    }

    /**
     * Method which helps modifying each row.
     *
     * @param   array $p_row
     *
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function modify_row(&$p_row)
    {
        if ($p_row['isys_catg_cmk_service_list__host'] > 0) {
            $p_row['isys_catg_cmk_service_list__host'] = isys_monitoring_dao_hosts::instance($this->get_database_component())
                ->get_data($p_row['isys_catg_cmk_service_list__host'], C__MONITORING__TYPE_LIVESTATUS)
                ->get_row_value('isys_monitoring_hosts__title');
        }
    }

    /**
     * Method for retrieving the displayable fields.
     *
     * @return  array
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function get_fields()
    {
        return [
            "isys_catg_cmk_service_list__id"      => "ID",
            "isys_catg_cmk_service_list__host"    => "LC__MODULE__CHECK_MK__HOST",
            "isys_catg_cmk_service_list__service" => "LC__CATG__CMK_SERVICE__CHECK_MK_SERVICES"
        ];
    }
}