<?php

use idoit\Console\IdoitConsoleApplication;
use idoit\Module\Check_mk\Console\Command\CheckMkExportCommand;
use idoit\Module\Check_mk\Export;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\ConsoleOutput;

/**
 * Export controller
 *
 * @package     Modules
 * @subpackage  Check_MK
 * @author      Leonard Fischer <lfischer@i-doit.org>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.0
 */
class isys_handler_check_mk_export extends isys_handler
{
    /**
     * Initialization method.
     *
     * @return  boolean
     */
    public function init()
    {
        global $argv;
        $session = isys_application::instance()->container->get('session');
        if ($session->is_logged_in()) {
            $l_export_language = 0;
            $l_export_structure = Export::STRUCTURE_NONE;

            if (array_search('-l', $argv) !== false) {
                $l_export_language = (int)$argv[array_search('-l', $argv) + 1];
            }

            if (array_search('-x', $argv) !== false) {
                $l_export_structure = (int)$argv[array_search('-x', $argv) + 1];
            }

            $application = new IdoitConsoleApplication();
            $application->setAutoExit(false);

            $output = new ConsoleOutput();

            $output->writeln('<error>isys_handler_check_mk_export is deprecated, please use php console.php check_mk-export instead</error>');

            $commandParams = [
                'command'           => 'check_mk-export',
                '--user'            => 'loginBefore',
                '--password'        => 'loginBefore',
                '--tenantId'        => 'loginBefore',
                '--exportLanguage'  => $l_export_language,
                '--exportStructure' => $l_export_structure
            ];

            /**
             * @var $command \idoit\Console\Command\AbstractCommand
             */
            $command = new CheckMkExportCommand();
            $command->setSession($session);
            $command->setContainer(\isys_application::instance()->container);
            $command->setAuth(\isys_auth_system::instance());

            $application->add($command);

            $application->run(new ArrayInput($commandParams), $output);

            return true;
        }

        return false;
    }
}
