<?php

namespace idoit\Module\Syneticsgmbh_dnsdocumentation\Processor;

use idoit\Module\Syneticsgmbh_dnsdocumentation\Processor;
use isys_cmdb_dao;

/**
 * Class Activate
 *
 * @package   idoit\Module\Syneticsgmbh_dnsdocumentation\Processor
 * @copyright synetics GmbH
 * @license   https://i-doit.com
 */
class Activate extends Processor
{
    /**
     * @return void
     * @throws \idoit\Exception\JsonException
     * @throws \isys_exception_dao
     */
    public function process()
    {
        // Set object type groups to status normal when activating the add-on.
        $objectTypeGroups = $this->getDataFileContent('object-type-groups.json');

        if (\count($objectTypeGroups)) {
            $this->activateObjectTypeGroups($objectTypeGroups);
        }

        // Set custom categories to status normal when activating the add-on.
        $customCategories = $this->getDataFileContent('custom-categories.json');

        if (\count($customCategories)) {
            $this->activateCustomCategories($customCategories);
        }
    }

    /**
     * @param array $objectTypeGroups
     *
     * @throws \isys_exception_dao
     */
    private function activateObjectTypeGroups(array $objectTypeGroups)
    {
        $dao = isys_cmdb_dao::instance($this->database);
        $statusNormal = $dao->convert_sql_int(C__RECORD_STATUS__NORMAL);

        // Remove any created object type groups.
        $objectTypeGroupConstants = implode(', ', array_filter(array_unique(array_map(function ($objectTypeGroup) use ($dao) {
            return $dao->convert_sql_text($objectTypeGroup['constant']);
        }, $objectTypeGroups))));

        $dao->update("UPDATE isys_obj_type_group SET isys_obj_type_group__status = {$statusNormal} WHERE isys_obj_type_group__const IN ({$objectTypeGroupConstants});");
        $dao->apply_update();
    }

    /**
     * @param array $customCategories
     *
     * @throws \isys_exception_dao
     */
    private function activateCustomCategories(array $customCategories)
    {
        $dao = isys_cmdb_dao::instance($this->database);
        $statusNormal = $dao->convert_sql_int(C__RECORD_STATUS__NORMAL);

        $customCategoryConstants = implode(', ', array_filter(array_unique(array_map(function ($customCategory) use ($dao) {
            return $dao->convert_sql_text($customCategory['constant']);
        }, $customCategories))));

        $dao->update("UPDATE isysgui_catg_custom SET isysgui_catg_custom__status = {$statusNormal} WHERE isysgui_catg_custom__const IN ({$customCategoryConstants});");
        $dao->apply_update();

    }
}
