<?php

/**
 * i-doit
 *
 * API model
 *
 * @package i-doit
 * @subpackage API
 * @copyright synetics GmbH
 * @license http://www.i-doit.com/license
 */
class isys_api_model_document extends isys_api_model implements isys_api_model_interface
{
    /**
     * Reads data.
     *
     * @param string $p_method Data method
     * @param array  $p_params Parameters (depends on data method)
     *
     * @throws isys_exception_api
     * @return isys_api_model_cmdb Returns itself.
     */
    public function route($p_method, $p_params)
    {
        // Build model class
        $l_modelclass = 'isys_api_model_document_' . $p_method;

        // Call data method and format data:
        if (!class_exists($l_modelclass)) {
            $this->m_log->error('Method "' . $p_method . '" does not exit.');
            throw new isys_exception_api('API Method "' . $p_method . '" (' . $l_modelclass . ') does not exist.', -32601);
        }

        if (!is_object($this->m_db)) {
            throw new isys_exception_api('Database not loaded. Your login may did not work!');
        }

        $l_model = new $l_modelclass();
        $l_method = 'read';

        if (isset($p_params['option']) && in_array($p_params['option'], ['read', 'create', 'update', 'delete'])) {
            $l_method = $p_params['option'];
        }

        // Check for mandatory parameters.
        $l_validation = $l_model->get_validation();
        if (isset($l_validation[$l_method]) && is_array($l_validation[$l_method])) {
            foreach ($l_validation[$l_method] as $l_validate) {
                if ($l_validate && !isset($p_params[$l_validate])) {
                    throw new isys_exception_api('Mandatory parameter \'' . $l_validate . '\' not found in your request.', -32602);
                }
            }
        }

        if (method_exists($l_model, $l_method)) {
            $this->m_log->info('Retrieving data from: ' . $p_method);
            $this->format($l_model->$l_method($p_params));
        }

        return $this;
    }

    /**
     * Formats data array by mapping and encodes data to UTF-8.
     *
     * @param array $p_mapping The mapping itself
     * @param array $p_row     Data array
     *
     * @return array Formatted data array
     */
    protected function format_by_mapping(array $p_mapping, $p_row)
    {
        $l_return = [];

        foreach ($p_mapping as $l_key => $l_map) {
            if (isset($p_row[$l_key]) || is_array($l_map)) {
                if (is_array($l_map)) {
                    $l_return[$l_map[1]] = call_user_func_array(
                        $l_map[0],
                        [$p_row[$l_key], $p_row]
                    );
                } else {
                    $l_return[$l_map] = $p_row[$l_key];
                }
            }
        }

        return $l_return;
    }

    public function read($p_params)
    {

    }
}
