<?php

use idoit\Module\Document\CustomFields\Entity\CustomField;

/**
 * i-doit
 *
 * Document Store Model
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Selcuk Kekec <skekec@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.0
 */
class isys_document_compiler_model_document extends isys_document_compiler_model
{
    /**
     * Fullname.
     *
     * @var  string
     */
    protected $m_author;

    /**
     * Date formated in user-specified format.
     *
     * @var  string
     */
    protected $m_created;

    /**
     * Document type.
     *
     * @var  string
     */
    protected $m_document_type;

    /**
     * Array of chapter models.
     *
     * @var  isys_document_compiler_model_chapter[]
     */
    protected $m_chapters = [];

    /**
     * Index as HTML.
     *
     * @var  string
     */
    protected $m_raw_index = null;

    /**
     * Header as HTML.
     *
     * @var  string
     */
    protected $m_raw_header = null;

    /**
     * Footer as HTML.
     *
     * @var  string
     */
    protected $m_raw_footer = null;

    /**
     * @var CustomField[]
     */
    protected $customFields;

    /**
     * @var string
     */
    protected $description;

    /**
     * Index as HTML.
     *
     * @var  string
     */
    protected $m_index = null;

    /**
     * Header as HTML.
     *
     * @var  string
     */
    protected $m_header = null;

    /**
     * Footer as HTML.
     *
     * @var  string
     */
    protected $m_footer = null;

    /**
     * Get Header.
     *
     * @return  string
     */
    public function get_raw_header()
    {
        return $this->m_raw_header;
    }

    /**
     * Set header.
     *
     * @param   string $p_raw_header
     *
     * @return  isys_document_compiler_model_document
     */
    public function set_raw_header($p_raw_header)
    {
        $this->m_raw_header = $p_raw_header;

        return $this;
    }

    /**
     * Get Header.
     *
     * @return  string
     */
    public function get_header()
    {
        return $this->m_header;
    }

    /**
     * Set header.
     *
     * @param   string $p_header
     *
     * @return  isys_document_compiler_model_document
     */
    public function set_header($p_header)
    {
        $this->m_header = $p_header;

        return $this;
    }

    /**
     * Get index.
     *
     * @return  string
     */
    public function get_index()
    {
        return $this->m_index;
    }

    /**
     * Set index.
     *
     * @param   string $p_index
     *
     * @return  isys_document_compiler_model_document
     */
    public function set_index($p_index)
    {
        $this->m_index = $p_index;

        return $this;
    }

    /**
     * Get Header.
     *
     * @return  string
     */
    public function get_footer()
    {
        return $this->m_footer;
    }

    /**
     * Set footer.
     *
     * @param   string $p_footer
     *
     * @return  isys_document_compiler_model_document
     */
    public function set_footer($p_footer)
    {
        $this->m_footer = $p_footer;

        return $this;
    }

    /**
     * Get Header.
     *
     * @return  string
     */
    public function get_raw_footer()
    {
        return $this->m_raw_footer;
    }

    /**
     * Set footer.
     *
     * @param   string $p_raw_footer
     *
     * @return  isys_document_compiler_model_document
     */
    public function set_raw_footer($p_raw_footer)
    {
        $this->m_raw_footer = $p_raw_footer;

        return $this;
    }

    /**
     * Set index.
     *
     * @return  string
     */
    public function get_raw_index()
    {
        return $this->m_raw_index;
    }

    /**
     * Set index.
     *
     * @param   string $p_raw_index
     *
     * @return  isys_document_compiler_model_document
     */
    public function set_raw_index($p_raw_index)
    {
        $this->m_raw_index = $p_raw_index;

        return $this;
    }

    /**
     * Get Author fullname.
     *
     * @return  string
     */
    public function get_author()
    {
        return $this->m_author;
    }

    /**
     * Set authors fullname.
     *
     * @param   string $p_author
     *
     * @return  isys_document_compiler_model_document
     */
    public function set_author($p_author)
    {
        $this->m_author = $p_author;

        return $this;
    }

    /**
     * Get timestamp of creation.
     *
     * @return  int
     */
    public function get_created()
    {
        return $this->m_created;
    }

    /**
     * Date of creation (timestamp).
     *
     * @param   int $p_created
     *
     * @return  isys_document_compiler_model_document
     */
    public function set_created($p_created)
    {
        $this->m_created = (int)$p_created;

        return $this;
    }

    /**
     * Returns the document type.
     *
     * @return  string
     */
    public function get_document_type()
    {
        return $this->m_document_type;
    }

    /**
     * Set the type of the document.
     *
     * @param   $p_document_type
     *
     * @return  isys_document_compiler_model_document
     */
    public function set_document_type($p_document_type)
    {
        $this->m_document_type = $p_document_type;

        return $this;
    }

    /**
     * Get the document description.
     *
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Set the document description.
     *
     * @param  string $description
     *
     * @return $this
     */
    public function setDescription($description)
    {
        $this->description = $description;

        return $this;
    }

    /**
     * Get the custom fields.
     *
     * @return CustomField[]
     */
    public function getCustomFields()
    {
        return $this->customFields;
    }

    /**
     * Set custom fields.
     *
     * @param CustomField[] $customFields
     *
     * @return $this
     */
    public function setCustomFields(array $customFields)
    {
        $this->customFields = $customFields;

        return $this;
    }

    /**
     * Get chapter models.
     *
     * @return  isys_document_compiler_model_chapter[]
     */
    public function get_chapters()
    {
        return $this->m_chapters;
    }

    /**
     * Add a new chapter.
     *
     * @param  isys_document_compiler_model_chapter $p_model_chapter
     */
    public function add_chapter(isys_document_compiler_model_chapter $p_model_chapter)
    {
        $this->m_chapters[] = $p_model_chapter;
    }

    /**
     * Clear all chapters.
     *
     * @return  isys_document_compiler_model_document
     */
    public function clear_chapters()
    {
        $this->m_chapters = [];

        return $this;
    }

    /**
     * Load full datastructure of a document template.
     *
     * @param  integer                    $p_document_templateID
     * @param  isys_document_dao_chapters $p_dao_document_chapters
     *
     * @return isys_document_compiler_model_document
     * @throws isys_exception_database
     * @throws isys_exception_general
     */
    public function load($p_document_templateID, isys_document_dao_chapters $p_dao_document_chapters)
    {
        $this->clear_chapters();

        // Get document data.
        $l_document_res = $p_dao_document_chapters->retrieve("SELECT isys_document_template__id, isys_document_type__title, isys_document_template__title
			FROM isys_document_template
			LEFT JOIN isys_document_type ON isys_document_type__id = isys_document_template__isys_document_type__id
			WHERE isys_document_template__id = " . $p_dao_document_chapters->convert_sql_id($p_document_templateID) . ";");

        if ($l_document_res->count() > 0) {
            $l_document_data = $l_document_res->get_row();
            $this->set_document_type(_L($l_document_data['isys_document_type__title']));
            $this->set_title(_L($l_document_data['isys_document_template__title']));

            // Load chapters.
            $l_chapters_data = $p_dao_document_chapters->get_chapter_tree_in_single_level($p_document_templateID, true);

            if ($l_chapters_data !== null && count($l_chapters_data) > 0) {
                // Create chapter models.
                foreach ($l_chapters_data AS $l_chapter_data) {
                    $l_tmp = new isys_document_compiler_model_chapter($this->m_options);

                    // Set model-data.
                    $l_tmp->set_title($l_chapter_data['title'])
                        ->set_document($this)
                        ->set_level((int)$l_chapter_data['level'])
                        ->set_chapter_num($l_chapter_data['position'])
                        ->set_raw_text($l_chapter_data['text'])
                        ->set_new_page((bool)$l_chapter_data['new_page']);

                    $this->add_chapter($l_tmp);
                }
            } else {
                throw new isys_exception_general(_L("LC__MODULE__DOCUMENT__ERROR__NO_CHAPTERS_DEFINED"));
            }
        } else {
            throw new isys_exception_general(_L("LC__MODULE__DOCUMENT__ERROR__DOCUMENT_TEMPLATE_DOES_NOT_EXIST", array($p_document_templateID)));
        }

        return $this;
    }
}
