<?php

use idoit\Module\Document\CustomFields\Value\DateTimeValue;
use idoit\Module\Document\CustomFields\Value\DateValue;
use idoit\Module\Document\CustomFields\Value\ObjectValue;
use idoit\Module\Document\CustomFields\Value\TextareaValue;

/**
 * i-doit Placeholder TemplateVars
 *
 * @package     Document
 * @subpackage  Compiler
 * @author      Selcuk Kekec <skekec@synetics.de>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_document_compiler_placeholder_template_var extends isys_document_compiler_placeholder
{
    /**
     * Compiler
     *
     * @return  string  compiled string
     */
    protected function get()
    {
        if (strpos($this->m_data['data']['key'], 'custom-field-') === 0) {
            return $this->handleCustomFields((int) substr($this->m_data['data']['key'], 13));
        }

        switch ($this->m_data['data']['key']) {
            case 'document_title':
                $l_compiled_placeholder = $this->get_compiler()
                    ->get_document()
                    ->get_model()
                    ->get_title();
                self::cache($l_compiled_placeholder);
                break;

            case 'document_type':
                $l_compiled_placeholder = $this->get_compiler()
                    ->get_document()
                    ->get_model()
                    ->get_document_type();
                self::cache($l_compiled_placeholder);
                break;

            case 'chapter_title':
                $l_compiled_placeholder = $this->get_compiler()
                    ->get_model()
                    ->get_title();
                self::cache($l_compiled_placeholder);
                break;

            case 'author_name':
                $l_compiled_placeholder = $this->get_compiler()
                    ->get_document()
                    ->get_model()
                    ->get_author();
                break;

            case 'creation_date':
                $createdTime = $this->get_compiler()
                    ->get_document()
                    ->get_model()
                    ->get_created();

                $l_compiled_placeholder = isys_application::instance()->container->get('locales')->fmt_date($createdTime);
                break;

            case 'creation_date_time':
                $createdTime = $this->get_compiler()
                    ->get_document()
                    ->get_model()
                    ->get_created();

                $l_compiled_placeholder = isys_application::instance()->container->get('locales')->fmt_datetime($createdTime);
                break;

            case 'current_page':
                // This is necessary, because the variable can only be replaced by the PDF library.
                $l_compiled_placeholder = '%%CURRENT_PAGE%%';
                break;

            case 'total_pages':
                // This is necessary, because the variable can only be replaced by the PDF library.
                $l_compiled_placeholder = '%%TOTAL_PAGES%%';
                break;

            case 'revision':
                // DOKU-273  This is necessary, because the variable can only be replaced after compilation.
                $l_compiled_placeholder = '%%REVISION_ID%%';
                break;

            case 'commentary':
                // DOKU-273  New variable.
                $l_compiled_placeholder = $this->get_compiler()
                    ->get_document()
                    ->get_model()
                    ->getDescription();
                break;

            case 'revision_comment':
                // DOKU-273  New variable.
                $l_compiled_placeholder = '%%REVISION_COMMENT%%';
                break;

            default:
                $l_compiled_placeholder = 'Variable "' . $this->m_data['data']['key'] . '" does not exist.';
        }

        return $l_compiled_placeholder;
    }

    /**
     * Method for handling custom field values.
     *
     * @param  integer $customFieldId
     *
     * @return string
     */
    private function handleCustomFields($customFieldId)
    {
        /** @var \idoit\Module\Document\CustomFields\Entity\CustomField[] $customFields */
        $customFields = $this->get_compiler()->get_document()->get_model()->getCustomFields();
        $language = isys_application::instance()->container->get('language');

        foreach ($customFields as $customField) {
            if ($customFieldId === $customField->getId()) {
                return $customField->getValue()->getFormattedValue() ?: $customField->getDefaultValue()->getFormattedValue();
            }
        }

        return '';
    }

    /**
     * Not needed
     */
    protected function post()
    {
    }

    /**
     * Not needed
     */
    protected function pre()
    {
    }
}
