<?php

/**
 * i-doit
 *
 * Document DAO.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Selcuk Kekec <skekec@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.3.0
 */
class isys_document_dao extends isys_component_dao
{
	/**
	 * Method for retrieving documents.
	 *
     * @param  int|array $p_id
     * @param  integer   $p_type
     * @param  string    $p_condition
     *
     * @return isys_component_dao_result
     * @throws isys_exception_database
     * @author Selcuk Kekec <skekec@i-doit.com>
     */
    public function get_data($p_id = null, $p_type = null, $p_condition = null)
    {
        $l_sql = 'SELECT * FROM isys_document
			LEFT JOIN isys_document_type ON isys_document__isys_document_type__id = isys_document_type__id
			LEFT JOIN isys_catg_document_list ON isys_catg_document_list__isys_document__id = isys_document__id
			LEFT JOIN isys_obj ON isys_catg_document_list__isys_obj__id = isys_obj__id
			LEFT JOIN isys_document_template ON isys_document__isys_document_template__id = isys_document_template__id
			WHERE TRUE ' . $p_condition;

        if ($p_id !== null) {
            if (is_array($p_id)) {
                $l_sql .= ' AND isys_document__id ' . $this->prepare_in_condition($p_id);
            } else {
                $l_sql .= ' AND isys_document__id = ' . $this->convert_sql_id($p_id);
            }
        }

        if ($p_type !== null) {
            $l_sql .= ' AND isys_document__isys_document_type__id = ' . $this->convert_sql_id($p_type);
        }

        return $this->retrieve($l_sql . ';');
    }


	/**
	 * Method for creating/saving a document.
	 *
     * @param  integer $p_id
     * @param  array   $p_values
     * @param  integer $objectId
     *
     * @return int|null
     * @throws isys_exception_dao
     * @author Selcuk Kekec <skekec@i-doit.com>
     */
    public function saveDocument($p_id = null, array $p_values = [], $objectId = null)
    {
        $l_data = [];

        if ($p_id === null || empty($p_id)) {
            $l_sql = 'INSERT INTO isys_document SET %s;';
            $l_data[] = 'isys_document__isys_document_type__id = (SELECT isys_document_template__isys_document_type__id FROM isys_document_template WHERE isys_document_template__id = ' . $this->convert_sql_id($p_values['isys_document_template__id']) . ')';
        } else {
            $l_sql = 'UPDATE isys_document SET %s WHERE isys_document__id = ' . $this->convert_sql_id($p_id) . ';';
        }

        if (count($p_values) > 0) {
            foreach ($p_values as $l_key => $l_value) {
                $l_data[] = 'isys_document__' . $l_key . ' = ' . $this->convert_sql_text($l_value);
            }

            if ($this->update(str_replace('%s', implode(', ', $l_data), $l_sql)) && $this->apply_update()) {
                $p_id = $p_id ?: $this->get_last_insert_id();

                if ($objectId !== null) {
                    $l_sql = 'INSERT INTO isys_catg_document_list SET
						isys_catg_document_list__isys_obj__id = ' . $this->convert_sql_id($objectId) . ',
						isys_catg_document_list__isys_document__id = ' . $this->convert_sql_id($p_id) . ',
						isys_catg_document_list__status = ' . $this->convert_sql_int(C__RECORD_STATUS__NORMAL) . ';';

                    $this->update($l_sql) && $this->apply_update();
                }
            }
        }

        return $p_id;
    }

    /**
     * Remove a document
     *
     * @param   int|array $documentIds
     *
     * @return  boolean
     * @author  Selcuk Kekec <skekec@i-doit.com>
     */
    public function deleteDocument($documentIds)
    {
        return $this->update('DELETE FROM isys_document WHERE isys_document__id ' . $this->prepare_in_condition((array)$documentIds) . ';') && $this->apply_update();
    }

    /**
     * Delete documents which are associated with given objects.
     *
     * @param array $objectIds
     *
     * @return bool
     */
    public function deleteDocumentsAssociatedToObject($categoryId, array $objectIds)
    {
        $sql = 'DELETE FROM isys_document
            WHERE isys_document__id IN (
                SELECT isys_catg_document_list__isys_document__id
                FROM isys_catg_document_list
                WHERE isys_catg_document_list__id = ' . $this->convert_sql_id($categoryId) . '
                AND isys_catg_document_list__isys_obj__id ' . $this->prepare_in_condition($objectIds) . '
            );';

        return $this->update($sql) && $this->apply_update();
    }

    /**
     * Load models of document as array.
     *
     * @param   integer $documentId
     *
     * @return  array    Array of isys_document_export_model
     */
    public function load_models_for_document($documentId)
    {
        $models = [];

        // Select models.
        $documentTextResult = $this->retrieve('SELECT * FROM isys_document_text WHERE isys_document_text__isys_document__id = ' . $this->convert_sql_id($documentId) . ';');

        if ($documentTextResult->count()) {
            // Build model array.
            while ($row = $documentTextResult->get_row()) {
                $tmp = new isys_document_export_model();

                $models[] = $tmp->set_level((int)$row['isys_document_text__level'])
                    ->set_pos($row['isys_document_text__pos'])
                    ->set_text($row['isys_document_text__text'])
                    ->set_title($row['isys_document_text__title']);

                unset($tmp);
            }
        }

        return $models;
    }
}
