<?php

/**
 * i-doit
 *
 * Popup class for creating placeholder for the main object.
 *
 * @package     i-doit
 * @subpackage  Popups
 * @author      Selcuk Kekec <skekec@i-doit.de>
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_popup_document_placeholder_object extends isys_component_popup
{
    /**
     * Handle request.
     *
     * @param isys_module_request $moduleRequest
     *
     * @return isys_component_template|void
     * @throws \idoit\Exception\JsonException
     * @throws isys_exception_database
     */
    public function &handle_module_request(isys_module_request $moduleRequest)
    {
        $l_preselection = [
            'root' => null,
            'lvls' => null
        ];

        if (isset($_POST['data']) && isys_format_json::is_json_array($_POST['data'])) {
            $l_preselection = static::handle_preselection(isys_format_json::decode($_POST['data']));
        }

        // Define some rules for our property selector.
        $l_rules = [
            'document_popup_property_selector'            => [
                'grouping'          => false,
                'sortable'          => true,
                'p_bInfoIconSpacer' => 0,
                'provide'           => C__PROPERTY__PROVIDES__REPORT,
                'p_consider_rights' => true,
                'custom_fields'     => true,
                'report'            => true,
                'dialog_width'      => '280px',
                'preselection'      => $l_preselection['root'],
                'preselection_lvls' => $l_preselection['lvls']
            ],
            'document-popup-report-header-background'     => [
                'size'       => 'mini',
                'p_strValue' => '#ffffff',
                'parent'     => '#document-popup .popup-content'
            ],
            'document-popup-report-header-textcolor'      => [
                'size'       => 'mini',
                'p_strValue' => '#000000',
                'parent'     => '#document-popup .popup-content'
            ],
            'document_property_options_border'            => [
                'p_arData'        => [
                    0            => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_GRID__NONE'),
                    'horizontal' => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_GRID__HORIZONTAL'),
                    'vertical'   => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_GRID__VERTICAL'),
                    'all'        => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_GRID__ALL')
                ],
                'p_bSort'         => false,
                'p_strSelectedID' => 'all',
                'p_bDbFieldNN'    => true,
                'p_strClass'      => 'input-mini'
            ],
            'document-popup-report-zebra-grid'            => [
                'size'       => 'mini',
                'p_strValue' => 'ffffff',
                'parent'     => '#document-popup .popup-content'
            ],
            'document-popup-report-show-after-page-break' => [
                'p_arData'        => [
                    1 => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_AFTER_PAGE_BREAK__YES'),
                    0 => $this->language->get('LC__MODULE__DOCUMENT__PLACEHOLDER__REPORT__DISPLAY_AFTER_PAGE_BREAK__NO')
                ],
                'p_bSort'         => false,
                'p_strSelectedID' => 1,
                'p_bDbFieldNN'    => true,
                'p_strClass'      => 'input-small'
            ],
            'conditional_message_empty' => [
                'p_strClass' => 'input-small',
            ],
            'conditional_message_full_top' => [
                'p_strClass' => 'input-small',
            ],
            'conditional_message_full_bottom' => [
                'p_strClass' => 'input-small',
            ],
        ];

        $this->template
            ->activate_editmode()
            ->assign('multiValueCategories', $this->getMultiValueCategories())
            ->smarty_tom_add_rules('tom.popup.placeholder', $l_rules)
            ->display(isys_module_document::getPath() . 'templates/popup/placeholder_object.tpl');

        die();
    }

    /**
     * @return array
     * @throws isys_exception_database
     */
    private function getMultiValueCategories()
    {
        $dao = isys_cmdb_dao::instance($this->database);
        $multiValueCategories = [];

        $result = $dao->retrieve('SELECT isysgui_catg__const AS const FROM isysgui_catg WHERE isysgui_catg__list_multi_value = 1;');

        while ($row = $result->get_row()) {
            $multiValueCategories[] = $row['const'];
        }

        $result = $dao->retrieve('SELECT isysgui_cats__const AS const FROM isysgui_cats WHERE isysgui_cats__list_multi_value = 1;');

        while ($row = $result->get_row()) {
            $multiValueCategories[] = $row['const'];
        }

        $result = $dao->retrieve('SELECT isysgui_catg_custom__const AS const FROM isysgui_catg_custom WHERE isysgui_catg_custom__list_multi_value = 1;');

        while ($row = $result->get_row()) {
            $multiValueCategories[] = $row['const'];
        }

        return $multiValueCategories;
    }

    /**
     * Preselection helper for the property selector.
     *
     * @param   array $p_data
     *
     * @return  array
     * @throws  Exception
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public static function handle_preselection(array $p_data = [])
    {
        $l_root = $l_lvls = [];
        //additional checking (&& $p_data['data']['showGrid']) was removed because '0' is perceived as false. DOCU-352
        if (isset($p_data['data']['showGrid']) || (isset($p_data['data']['optBorder']) && $p_data['data']['optBorder']) || (isset($p_data['data']['optHeader']) && $p_data['data']['optHeader'])) {
            // If these options are set, we are handling multiple properties ("display as table").
            $l_preselection = isys_format_json::decode($p_data['data']['propData']);
            $l_cnt = 1;

            if (is_array($l_preselection) && count($l_preselection)) {
                foreach ($l_preselection as $l_type => $l_data) {
                    if ($l_type === 'root') {
                        $l_root = isys_format_json::encode($l_data);
                    } else {
                        $l_lvls[$l_cnt++] = [
                            $l_type => $l_data
                        ];
                    }
                }
            }
        } elseif (isset($p_data['data']['catg_type']) && isset($p_data['data']['catg']) && !empty($p_data['data']['catg_type']) && !empty($p_data['data']['catg'])) {
            // Display a single property.
            if (isset($p_data['data']['refKey'])) {
                $l_cnt = 1;
                $l_refkeys = explode('--', $p_data['data']['refKey']);

                $l_root_refkey = explode('-', $l_refkeys[0]);

                // Find out what sort of category the root element is (global, specific, custom).
                $l_dao = new isys_cmdb_dao_category_property(isys_application::instance()->container->get('database'));
                $l_root_cat_type = $l_dao->get_cat_by_const($l_root_refkey[0]);
                $l_root_property = $l_dao->retrieve_properties(
                    null,
                    null,
                    null,
                    null,
                    'AND isys_property_2_cat__cat_const = ' . $l_dao->convert_sql_text($l_root_refkey[0]) . ' AND isys_property_2_cat__prop_key = ' .
                    $l_dao->convert_sql_text($l_root_refkey[1])
                )
                    ->get_row();

                switch ($l_root_cat_type['type']) {
                    default:
                    case C__CMDB__CATEGORY__TYPE_GLOBAL:
                        $l_root_cat_type = 'g';
                        break;
                    case C__CMDB__CATEGORY__TYPE_SPECIFIC:
                        $l_root_cat_type = 's';
                        break;
                    case C__CMDB__CATEGORY__TYPE_CUSTOM:
                        $l_root_cat_type = 'g_custom';
                        break;
                }

                $l_root = isys_format_json::encode([
                    [
                        $l_root_cat_type => [
                            $l_root_refkey[0] => [
                                $l_root_property['id'],
                                $l_root_refkey[1],
                                isys_application::instance()->container->get('language')
                                    ->get($l_root_property['title'])
                            ]
                        ]
                    ]
                ]);

                $l_keys = [];

                foreach ($l_refkeys as $l_index => $l_refkey) {
                    $l_keys[] = $l_refkey;
                    $l_level_refkey = explode('-', $l_refkey);
                    $l_level_cat_type = $l_dao->get_cat_by_const($l_level_refkey[0]);

                    if ($l_index == (count($l_refkeys) - 1)) {
                        // We are currently iterating the last item, so we need to switch some values.
                        $l_cat = $p_data['data']['catg'];
                        $l_level_cat_type = $p_data['data']['catg_type'];
                        $l_prop = $p_data['data']['prop'];
                        $l_prop_name = $p_data['data']['propName'];
                    } else {
                        if (isset($l_refkeys[$l_index + 1])) {
                            $l_level_refkey = explode('-', $l_refkeys[$l_index + 1]);
                            $l_level_cat_type = $l_dao->get_cat_by_const($l_level_refkey[0]);
                        }

                        $l_level_property = $l_dao->retrieve_properties(
                            null,
                            null,
                            null,
                            null,
                            'AND isys_property_2_cat__cat_const = ' . $l_dao->convert_sql_text($l_level_refkey[0]) . ' AND isys_property_2_cat__prop_key = ' .
                            $l_dao->convert_sql_text($l_level_refkey[1]),
                            true
                        )
                            ->get_row();

                        switch ($l_level_cat_type['type']) {
                            default:
                            case C__CMDB__CATEGORY__TYPE_GLOBAL:
                                $l_level_cat_type = 'g';
                                break;
                            case C__CMDB__CATEGORY__TYPE_SPECIFIC:
                                $l_level_cat_type = 's';
                                break;
                            case C__CMDB__CATEGORY__TYPE_CUSTOM:
                                $l_level_cat_type = 'g_custom';
                                break;
                        }

                        $l_cat = $l_level_refkey[0];
                        $l_prop = $l_level_refkey[1];
                        $l_prop_name = isys_application::instance()->container->get('language')
                            ->get($l_level_property['title']);
                    }

                    $l_lvls[$l_cnt++] = [
                        implode('--', $l_keys) => [
                            0 => [
                                $l_level_cat_type => [
                                    $l_cat => [
                                        null,
                                        $l_prop,
                                        $l_prop_name
                                    ]
                                ]
                            ]
                        ]
                    ];
                }
            } else {
                $l_root = isys_format_json::encode([
                    [
                        $p_data['data']['catg_type'] => [
                            $p_data['data']['catg'] => [
                                null,
                                $p_data['data']['prop'],
                                $p_data['data']['propName']
                            ]
                        ]
                    ]
                ]);
            }
        }

        return [
            'root' => $l_root,
            'lvls' => $l_lvls
        ];
    }
}
