<?php

namespace idoit\Module\Document\CustomFields\Model;

use idoit\Model\Dao\Base;
use idoit\Module\Document\CustomFields\Entity\CustomField;

/**
 * i-doit custom-fields configuration model.
 *
 * @package     document
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       1.3.0
 */
class Configuration extends Base
{
    /**
     * @param  integer $documentId
     *
     * @return \isys_component_dao_result
     * @throws \isys_exception_database
     */
    public function getByDocumentTemplateId($documentId)
    {
        $select = parent::selectImplode([
            'isys_document_custom_field__id'            => 'id',
            'isys_document_custom_field__name'          => 'name',
            'isys_document_custom_field__datatype'      => 'dataType',
            'isys_document_custom_field__default_value' => 'defaultValue',
        ]);

        $sql = 'SELECT ' . $select . '
            FROM isys_document_custom_field 
            WHERE isys_document_custom_field__isys_document_template__id = ' . $this->convert_sql_id($documentId) . '
            ORDER BY isys_document_custom_field__sorting ASC;';

        return $this->retrieve($sql);
    }

    /**
     * @param  CustomField $customField
     * @param  integer     $index
     *
     * @return boolean
     * @throws \isys_exception_dao
     */
    public function saveCustomField(CustomField $customField, $index)
    {
        $fields = [
            'isys_document_custom_field__isys_document_template__id = ' . $this->convert_sql_id($customField->getTemplateId()),
            'isys_document_custom_field__name = ' . $this->convert_sql_text($customField->getName()),
            'isys_document_custom_field__datatype = ' . $this->convert_sql_text($customField->getDataType()),
            'isys_document_custom_field__default_value = ' . $this->convert_sql_text($customField->getDefaultValue()->getStringValue()),
            'isys_document_custom_field__sorting = ' . $this->convert_sql_int($index)
        ];

        $sql = 'INSERT INTO isys_document_custom_field 
            SET ' . implode(', ', $fields) . ';';

        if ($customField->getId() > 0) {
            $sql = 'UPDATE isys_document_custom_field 
                SET ' . implode(', ', $fields) . ' 
                WHERE isys_document_custom_field__id = ' . $this->convert_sql_id($customField->getId()) . ';';
        }

        return $this->update($sql) && $this->apply_update();
    }

    /**
     * @param  array $deletion
     *
     * @return boolean
     * @throws \isys_exception_dao
     */
    public function deleteCustomFields(array $deletion)
    {
        $sql = 'DELETE FROM isys_document_custom_field 
            WHERE isys_document_custom_field__id ' . $this->prepare_in_condition($deletion) . ';';

        return $this->update($sql) && $this->apply_update();
    }
}
