<?php

namespace idoit\Module\Document\CustomFields\Value;

use isys_application as Application;
use isys_cmdb_dao as DaoCmdb;
use isys_module_document;
use isys_smarty_plugin_f_popup;

/**
 * i-doit customfield object value.
 *
 * @package     document
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       1.3.0
 */
class ObjectValue extends AbstractCustomFieldValue
{
    const LABEL = 'LC__MODULE__DOCUMENT__CUSTOM_FIELDS__VALUE__OBJECTVALUE';

    /**
     * @inheritdoc
     */
    public function getStringValue()
    {
        return $this->value;
    }

    /**
     * @return string
     * @throws \isys_exception_database
     */
    public function getFormattedValue()
    {
        if (empty($this->value)) {
            return '';
        }

        $language = Application::instance()->container->get('language');
        $database = Application::instance()->container->get('database');

        $objectData = DaoCmdb::instance($database)->get_object($this->value)->get_row();

        return $language->get($objectData['isys_obj_type__title']) . ' &raquo; ' . $language->get($objectData['isys_obj__title']);
    }

    /**
     * @inheritdoc
     */
    public function getTemplate($name, $value, $editMode)
    {
        $smartyPlugin = new isys_smarty_plugin_f_popup();
        $template = Application::instance()->container->get('template');
        $parameters = [
            'id'             => $name,
            'name'           => $name,
            'p_strValue'     => $value,
            'p_strPopupType' => 'browser_object_ng',
            'edit_mode'      => $editMode
        ];

        if ($editMode) {
            return $smartyPlugin->navigation_edit($template, $parameters);
        }

        return $smartyPlugin->navigation_view($template, $parameters);
    }
}
