<div id="document-popup">
    <div class="popup-header-ng">
        <h1>[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE__TEMPLATE_IMPORT_BUTTON"}]</h1>
        <button type="button" class="btn btn-secondary popup-closer ml-auto" title="[{isys type="lang" ident="LC__POPUP__CLOSE"}]" data-tooltip="1">
            <img class="fr mouse-pointer" alt="" src="[{$dir_images}]axialis/user-interface/window-control-close.svg" />
        </button>
    </div>

    <div class="popup-content">
        <div class="p10">
            [{isys type="f_file_ajax" name="whatever" uploadType="document.import-template"}]
        </div>

        <hr class="mt10 mb10 hide" />

        <div id="document-popup-import-log" class="m5 hide">
            <h3 class="bg-neutral-200 border p5">Log</h3>
            <ul class="list-style-none m0 mt10"></ul>
        </div>
    </div>

    <div class="popup-footer">
        <button type="button" id="document-popup-close" class="btn popup-closer">
            <img src="[{$dir_images}]axialis/basic/symbol-cancel.svg" /><span>[{isys type="lang" ident="LC_UNIVERSAL__ABORT"}]</span>
        </button>
    </div>
</div>

<style type="text/css">
    #document-popup .input-file-ajax button {
        position: relative;
    }

    #document-popup-import-log li {
        padding: 5px;
        border-bottom: 1px solid #ccc;
    }

    #document-popup-import-log li span {
        display: inline-block;
        width: 440px;
        text-overflow: ellipsis;
        overflow: hidden;
    }

    #document-popup-import-log li:last-of-type {
        border-bottom: none;
    }
</style>

<script type="text/javascript">
    (function () {
        "use strict";

        var $popup                = $('document-popup'),
            $closeButton          = $('document-popup-close'),
            $log_window           = $('document-popup-import-log'),
            uploaded_and_imported = false;

        idoit.callbackManager.registerCallback('smarty-ajax-file-upload', (data) => {
            const log_types = JSON.parse('[{$loggerIcons|json_encode|escape:"javascript"}]');
            const $ul = $log_window.down('ul').update();

            if (data.callbackResult) {
                uploaded_and_imported = true;

                $closeButton
                    .down('img').removeClassName('animation-rotate').writeAttribute('src', '[{$dir_images}]axialis/basic/symbol-ok.svg')
                    .next('span').update('[{isys type="lang" ident="LC__NOTIFY__SUCCESS"}]');

                // Display the log.
                for (let i in data.callbackResult.log) {
                    if (data.callbackResult.log.hasOwnProperty(i)) {
                        $ul
                            .insert(new Element('li')
                                .update(new Element('img', {className: 'vam mr5', src: log_types[data.callbackResult.log[i].level]}))
                                .insert(new Element('span', {className: 'vam'}).update(data.callbackResult.log[i].message)));
                    }
                }

                $log_window.removeClassName('hide').previous('hr').removeClassName('hide');
            } else {
                $closeButton
                    .down('img').removeClassName('animation-rotate').writeAttribute('src', '[{$dir_images}]axialis/basic/symbol-cancel.svg')
                    .next('span').update('[{isys type="lang" ident="LC__NOTIFY__ERROR"}]');
            }
        });

        // Register a callback for "closing" the popup.
        $popup.on('click', '.popup-closer', function () {
            if (!uploaded_and_imported) {
                popup_close();
            } else {
                document.location.reload();
            }
        });
    })();
</script>
