<?php

use idoit\Module\Document\Controller\WysiwygController;
use Symfony\Component\Routing\Loader\Configurator\RoutingConfigurator;

return function (RoutingConfigurator $routes) {
    // CMDB object routes.
    $routes->add('document.wysiwyg.upload-image', '/document/wysiwyg/upload-image')
        ->methods(['POST'])
        ->controller([WysiwygController::class, 'uploadImage']);

    $routes->add('document.wysiwyg.browse-images', '/document/wysiwyg/browse-images')
        ->methods(['GET'])
        ->controller([WysiwygController::class, 'browseImages']);

    $routes->add('document.wysiwyg.delete-image', '/document/wysiwyg/delete-image')
        ->methods(['POST'])
        ->controller([WysiwygController::class, 'deleteImage']);

    // @see DOKU-457
    $routes->add('document.wysiwyg.custom-css', '/document/wysiwyg/custom-css')
        ->methods(['GET'])
        ->controller([WysiwygController::class, 'getCustomCss']);
};
