<?php

/**
 * i-doit
 *
 * Model: Data-holder for the exporters.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Selcuk Kekec <skekec@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.0
 */
class isys_document_export_model
{
    /**
     * @var string|null
     */
    protected ?string $text = null;

    /**
     * @var int|null
     */
    protected ?int $level = null;

    /**
     * @var string|null
     */
    protected ?string $position = null;

    /**
     * @var string|null
     */
    protected ?string $title = null;

    /**
     * @var bool|null
     */
    protected bool $newPage = false;

    /**
     * @return bool
     */
    public function get_new_page(): bool
    {
        return $this->newPage;
    }

    /**
     * @param bool $p_value
     *
     * @return $this
     */
    public function set_new_page(bool $p_value): self
    {
        $this->newPage = $p_value;

        return $this;
    }

    /**
     * @return self
     */
    public static function factory(): self
    {
        return new self();
    }

    /**
     * @return string
     */
    public function get_text(): string
    {
        return $this->text;
    }

    /**
     * @param string $p_text
     *
     * @return $this
     */
    public function set_text(string $p_text): self
    {
        $this->text = $p_text;

        return $this;
    }

    /**
     * @return int
     */
    public function get_level(): int
    {
        return $this->level;
    }

    /**
     * @param int $p_level
     *
     * @return $this
     */
    public function set_level(int $p_level): self
    {
        $this->level = $p_level;

        return $this;
    }

    /**
     * @return string
     */
    public function get_pos(): string
    {
        return $this->position;
    }

    /**
     * @param string $p_pos
     *
     * @return $this
     */
    public function set_pos(string $p_pos): self
    {
        $this->position = $p_pos;

        return $this;
    }

    /**
     * @return string
     */
    public function get_title(): string
    {
        return $this->title;
    }

    /**
     * @param string $p_title
     *
     * @return $this
     */
    public function set_title(string $p_title): self
    {
        $this->title = $p_title;

        return $this;
    }
}
