(function () {
	'use strict';

	idoit.callbackManager.registerCallback('document-refresh-tree', function () {
		var url = document.location.href.toQueryParams();

		url.ajax = 1;
		url.func = 'build_tree';

		new Ajax.Request('?' + Object.toQueryString(url), {
			method: 'post',
			onComplete: function (transport) {
				var $menuTreeJs = $('menuTreeJS');

				if ($menuTreeJs) {
					$menuTreeJs.update(transport.responseText)
				}
			}
		});
	});

	// The callback shall also be triggered, when we save something.
	document.observe("dom:loaded", function() {
		$('isys_form').on('form:saved', function () {
			idoit.callbackManager.triggerCallback('document-refresh-tree');
		});
	});
})();

