<?php

/**
 * i-doit Placeholder CategoryProperty
 *
 * @package    Modules
 * @subpackage Document
 * @author     Selcuk Kekec <skekec@synetics.de>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_document_compiler_placeholder_property extends isys_document_compiler_placeholder
{
    private static $m_ref_keys;

    private $m_category_types = [
        'g'        => C__CMDB__CATEGORY__TYPE_GLOBAL,
        'g_custom' => C__CMDB__CATEGORY__TYPE_CUSTOM,
        's'        => C__CMDB__CATEGORY__TYPE_SPECIFIC
    ];

    /**
     * Compiler
     *
     * @return  string  compiled string
     */
    protected function get()
    {
        $l_compiled_placeholder = '';

        if (!isset($this->m_data[C__CMDB__GET__OBJECT]) && !isset($this->m_data['data'][C__CMDB__GET__OBJECT])) {
            $this->m_data[C__CMDB__GET__OBJECT] = $this->get_compiler()
                ->get_master_object();
        } elseif (isset($this->m_data['data'][C__CMDB__GET__OBJECT]) && $this->m_data['data'][C__CMDB__GET__OBJECT] > 0) {
            $this->m_data[C__CMDB__GET__OBJECT] = $this->m_data['data'][C__CMDB__GET__OBJECT];
        }

        if ($this->m_data[C__CMDB__GET__OBJECT]) {
            $l_compiled_placeholder = $this->get_value($this->m_data[C__CMDB__GET__OBJECT], $this->m_data['data']['catg'], $this->m_data['data']['prop']);
        }

        return $l_compiled_placeholder;
    }

    /**
     * Transform category property to html.
     *
     * @param   int|array $p_objID
     * @param   string    $p_category_const
     * @param   string    $p_category_property
     *
     * @return  string
     */
    private function get_value($p_objID, $p_category_const, $p_category_property)
    {
        $l_value = null;
        $statusFilter = (array)(!empty($this->m_data['data']['status']) ? $this->m_data['data']['status'] : [C__RECORD_STATUS__NORMAL]);

        // Is category type existing?.
        if (isset($this->m_category_types[$this->m_data['data']['catg_type']])) {
            // Check if the selected property is a referenced property.
            if (count(self::$m_ref_keys) > 0) {
                $l_ref_keys = array_keys(self::$m_ref_keys);
                foreach ($l_ref_keys as $l_key) {
                    if (strpos($l_key, $p_category_const . '-' . $p_category_property) !== false) {
                        return '';
                    }
                }
            }

            if (isset($this->m_data['data']['refKey']) && $this->m_data['data']['refKey'] !== '') {
                // We have found a content chain.
                if (isset(self::$m_ref_keys[$this->m_data['data']['refKey']]) && self::$m_ref_keys[$this->m_data['data']['refKey']]) {
                    $p_objID = self::$m_ref_keys[$this->m_data['data']['refKey']];
                } else {
                    self::$m_ref_keys[$this->m_data['data']['refKey']] = $this->m_dao_property
                        ->reset()
                        ->setMultivalueStatusFilter($statusFilter)
                        ->retrieve_chained_obj_id($p_objID, $this->m_data['data']['refKey']);

                    if (self::$m_ref_keys[$this->m_data['data']['refKey']]) {
                        $p_objID = self::$m_ref_keys[$this->m_data['data']['refKey']];
                    }
                }
            }

            if (is_array($p_objID)) {
                $p_objID = $p_objID[0];
            }

            if ($p_objID > 0) {
                $l_const_arr = explode('_', $p_category_const);

                if ($l_const_arr[count($l_const_arr) - 1] === 'MASTER') {
                    $p_category_const = rtrim(str_replace('MASTER', '', $p_category_const), '_');
                }

                // Always get "fresh" data...
                isys_cmdb_dao_category_data::free($p_objID);

                $l_objData = isys_cmdb_dao_category_data::initialize($p_objID)
                    ->path($p_category_const)
                    ->data();

                if (count($l_objData) > 0) {
                    if ($this->m_data['showOnlyPrimaryEntry'] === true) {
                        $l_value = (string)isys_cmdb_dao_category_data::initialize($p_objID)
                            ->path($p_category_const)
                            ->data()
                            ->path('@primary.' . $p_category_property, '');
                    }

                    // When @primary does not work try iterating for an valid value
                    if (empty($l_value)) {
                        foreach (isys_cmdb_dao_category_data::initialize($p_objID)->path($p_category_const) as $row) {
                            if (($row instanceof isys_cmdb_dao_category_data || $row instanceof isys_array) && !empty($row->path($p_category_property))) {
                                $l_value = (string)$row->path($p_category_property);
                            } elseif (is_array($row)) {
                                $l_value = (string)$row[$p_category_property];
                            }
                        }
                    }
                } else {
                    $l_value = '';
                }
            }
        }

        if ($p_category_property === 'description') {
            return $l_value;
        }

        // Return normalized value.
        return $this->normalize($l_value);
    }

    /**
     * Method for resetting the ref key cache.
     *
     * @see DOKU-
     */
    public static function reset_ref_keys()
    {
        self::$m_ref_keys = [];
    }

    /**
     * Not needed
     */
    protected function post()
    {
    }

    /**
     * Object-ID Handling.
     */
    protected function pre()
    {
    }
}
