<?php
/**
 * i-doit
 *
 * Document component DAO.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Selcuk Kekec <skekec@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.3.0
 */
class isys_document_dao_components extends isys_component_dao
{
    /**
	 * Member variable for last component id
	 *
	 * @var null|int
	 */
	private static $m_last_component_id = null;


	/**
	 * Setter for last component id
	 *
	 * @param $p_value
	 */
	public static function set_last_component_id ($p_value)
	{
		self::$m_last_component_id = $p_value;
	} // function


	/**
	 * Getter for last component id
	 *
	 * @return int|null
	 */
	public static function get_last_component_id ()
	{
		return self::$m_last_component_id;
	} // function


    /**
     * Method for retrieving a component.
     *
     * @param   integer  $p_id
     * @param   integer  $p_documentID
     * @param   string   $p_condition
     * @return  isys_component_dao_result
     * @author  Selcuk Kekec <skekec@i-doit.com>
     */
	public function get_data ($p_id = null, $p_documentID = null, $p_condition=null)
	{
		$l_sql = 'SELECT * FROM isys_document_component '.
			'INNER JOIN isys_document_chapter ON isys_document_chapter__isys_document_component__id = isys_document_component__id '.
			'INNER JOIN isys_document_template ON isys_document_chapter__isys_document_template__id = isys_document_template__id '.
			'WHERE TRUE ';

		if ($p_id !== null)
		{
			if (is_array($p_id))
			{
				$l_sql .= ' AND isys_document_component__id IN (' . implode(', ', array_map('intval', $p_id)) . ')';
			}
			else
			{
				$l_sql .= ' AND isys_document_component__id = ' . $this->convert_sql_id($p_id);
			} // if
		} // if

		return $this->retrieve($l_sql . ' ' . $p_condition .  ';');
	} // function


	/**
	 * Method for creating/saving a component.
	 *
	 * @param   integer  $p_id
	 * @param   array    $p_values
	 * @return  integer
	 * @author  Selcuk Kekec <skekec@i-doit.com>
	 */
	public function saveComponent ($p_id = null, array $p_values = array())
	{
		$l_data = array();

		if ($p_id === null || empty($p_id))
		{
			$l_sql = 'INSERT INTO isys_document_component SET %s;';
		}
		else
		{
			$l_sql = 'UPDATE isys_document_component SET %s WHERE isys_document_component__id = ' . $this->convert_sql_id($p_id) . ';';
		} // if

		if (count($p_values) > 0)
		{
			foreach ($p_values as $l_key => $l_value)
			{
                $l_value = ($l_key == 'isys_document_component__isys_document_component__id') ? $l_value : $this->convert_sql_text($l_value);
				$l_data[] = 'isys_document_component__' . $l_key . ' = ' . $l_value;
			} // foreach

			$this->update(str_replace('%s', implode(', ', $l_data), $l_sql)) && $this->apply_update();
		} // if
		return (self::$m_last_component_id = ($p_id ?: $this->get_last_insert_id()));
	} // function


	/**
	 * Remove a documents component
	 *
	 * @param   mixed  $p_id
	 * @return  boolean
	 * @author  Selcuk Kekec <skekec@i-doit.com>
	 */
	public function deleteComponent ($p_id)
	{
		if (! is_array($p_id))
		{
			$p_id = array($p_id);
		} // if

		return ($this->update('DELETE FROM isys_document_component WHERE isys_document_component__id IN (' . implode(',', array_map('intval', $p_id)) . ');') && $this->apply_update());
	} // function
} // class
