<?php

use idoit\Console\IdoitConsoleApplication;
use idoit\Module\Document\Console\Command\CompileDocumentsCommand;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\ConsoleOutput;

/**
 * i-doit
 *
 * Handler: Documents
 *
 * @package     i-doit
 * @subpackage  Handler
 * @author      Selcuk Kekec <skekec@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_handler_document extends isys_handler
{
    /**
     * Log instance for this handler.
     * @var  isys_log
     */
    protected $m_log = null;

    /**
     * Constant for the "profile" parameter.
     * @var  string
     */
    const C__DOCUMENT_IDS = '-t';

    /**
     * Desctructor
     *
     * @todo  Move it to parent class!?
     */
    public function __destruct()
    {
        $this->logout();
    } // function


    /**
     * Method for retrieving the handler-title.
     *
     * @return  string
     */
    protected function get_title()
    {
        return 'Document-Handler';
    } // function


    /**
     * Initiates the handler.
     */
    public function init()
    {
        global $argv, $g_comp_session;

        if (($l_index = array_search(self::C__DOCUMENT_IDS, $argv)) !== false)
        {
            /* Does the option index exist */
            if (isset($argv[$l_index+1])) {
                $l_document_ids = explode(',', $argv[$l_index+1]);

                if (is_array($l_document_ids)) {
                    $application = new IdoitConsoleApplication();
                    $application->setAutoExit(false);

                    $output = new ConsoleOutput();

                    $output->writeln('<error>isys_handler_document is deprecated, please use php console.php CompileDocuments instead</error>');

                    $commandParams = [
                        'command' => 'CompileDocuments',
                        '--documentId' => $l_document_ids,
                        '--user' => 'loginBefore',
                        '--password' => 'loginBefore',
                        '--mandatorId' => 'loginBefore'
                    ];

                    /**
                     * @var $command \idoit\Console\Command\AbstractCommand
                     */
                    $command = new CompileDocumentsCommand();
                    $command->setSession($g_comp_session);
                    $command->setContainer(\isys_application::instance()->container);
                    $command->setAuth(\isys_auth_system::instance());

                    $application->add($command);

                    $application->run(new ArrayInput($commandParams), $output);
                }
            }
        } else {
            $this->usage();
        } // if
    } // function


    /**
     * Prints out the usage of he import handler.
     */
    public function usage()
    {
        echo "Missing parameters!\n" .
            "You have to use the following parameters in order for the document handler to work:\n\n" .
            "  " . self::C__DOCUMENT_IDS . " comma-seperate list of document ids\n" . PHP_EOL;

        die();
    } // function
} // class
