[{isys_group name="tom.popup.placeholder"}]
    <div id="document-popup">
        <h3 class="popup-header">
            <img class="fr mouse-pointer popup-closer" src="[{$dir_images}]prototip/styles/default/close.png"/>
            <span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__IMAGES"}]</span>
        </h3>

        <div id="document-popup-floorplan" class="popup-content p5">
            [{if !$featureAvailable}]
            <p class="p5 box-yellow">
                <img src="[{$dir_images}]icons/silk/error.png" class="vam mr5" />
                <span class="vam">[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__FLOORPLAN__INCOMPATIBLE_VERSION"}]</span>
            </p>
            [{else}]

            [{if $floorplanWithoutImage}]
            <p class="p5 box-blue">
                <img src="[{$dir_images}]icons/silk/information.png" class="vam mr5" />
                <span class="vam">[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__FLOORPLAN__NO_IMAGE"}]</span>
            </p>
            [{/if}]

            <ul class="m0 p0 list-style-none">
                <li class="p5">
                    <label class="vam">
                        <input type="radio" name="floorplan-id" value="0" checked/>
                        <span class="ml5">[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__MAINOBJECT__HEADER"}]</span>
                    </label>
                </li>
            </ul>

            [{if count($floorplans)}]
            <ul class="mr0 mb0 ml0 p0 list-style-none">
            [{foreach $floorplans as $floorplan}]
                <li class="p5">
                    <label class="display-block">
                        <input type="radio" name="floorplan-id" value="[{$floorplan.objectId}]" [{if empty($floorplan.snapshot)}]disabled[{/if}]/>
                        <span class="ml5">[{$floorplan.objectTitle}]</span>
                        [{if $floorplan.snapshot}]
                        <button type="button" class="btn btn-small ml5" data-image-uri="[{$floorplan.snapshot}]">
                            <span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__FLOORPLAN__PREVIEW"}]</span>
                        </button>
                        [{else}]
                        <a class="ml5" href="[{$floorplanUrl}][{$floorplan.objectId}]" target="_blank">
                            [{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__FLOORPLAN__LINK"}]
                        </a>
                        [{/if}]
                    </label>
                </li>
            [{/foreach}]
            </ul>
            [{else}]
            <p>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__FLOORPLAN__NO_FLOORPLANS"}]</p>
            [{/if}]
            [{/if}]
        </div>

        <div class="popup-footer">
            <button type="button" class="btn" id="document-popup-save-button">
                <img src="[{$dir_images}]icons/silk/tick.png" class="mr5"><span>[{isys type="lang" ident="LC__CMDB__OBJECT_BROWSER__SCRIPT__ADD"}]</span>
            </button>
            <button type="button" class="btn popup-closer">
                <img src="[{$dir_images}]icons/silk/cross.png" class="mr5"><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
            </button>
        </div>
    </div>

    <script type="text/javascript">
        (function () {
            "use strict";

            var widget = window.currently_selected_document_widget,
	            widget_data = widget.data,
	            editor = widget.editor,
                $content = $('document-popup-floorplan');

            $$('.popup-closer').invoke('on', 'click', function () {
                // If the user closes the popup, we want to destroy the widget!
                if (widget.data.data && widget.data.data.hasOwnProperty('id') && !widget.data.data.id) {
                    widget.remove_and_set_focus();
                }

                popup_close($('popup_placeholder'));

                window.currentEditor.focus();
            });

            $content.on('click', 'button', function(ev) {
                var $overlay = $('overlay'),
                    $button = ev.findElement('button'),
                    $previewImageContainer = new Element('div', {id: 'document-popup-floorplan-preview'}),
                    $previewImage = new Element('img', {src: $button.readAttribute('data-image-uri')});

                $previewImageContainer.on('click', function () {
                    $previewImageContainer.remove();
                });

                $previewImageContainer.setStyle({
                    width: ($overlay.getWidth() - 50) + 'px',
                    height: ($overlay.getHeight() - 50) + 'px'
                });

                $('wrapper').insert($previewImageContainer.insert($previewImage));
            });

            // And add some "accept" logic.
            $('document-popup-save-button').on('click', function (ev) {
                var $checkedRadiobox = $content.down(':checked');

                widget.setData({
                    type: 'floorplan',
                    data: {
                        objectId: $checkedRadiobox.getValue(),
                        objectTitle: $checkedRadiobox.next('span').innerText
                    }
                });

                popup_close($('popup_placeholder'));

                window.currentEditor.focus();
            });

	        // Finally handle the preselection:
	        if (widget_data.hasOwnProperty('data') && widget_data.data.hasOwnProperty('objectId')) {
                var $radioBox = $content.down('input[value="' + widget_data.data.objectId + '"]');

                if ($radioBox) {
                    $radioBox.setValue(1);
                } else {
                    var message = '[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__FLOORPLAN__PRESELECTION_WARNING"}]'
                        .replace(':title', widget_data.data.objectTitle)
                        .replace(':id', widget_data.data.objectId);

                    idoit.Notify.warning(message, {sticky: true});
                }
	        }
        })();
    </script>

    <style type="text/css">
        #document-popup-floorplan li:hover {
            background: #f0f0f0;
        }

        #document-popup-floorplan li label {
            position: relative;
            height: auto;
            cursor: pointer;
            padding-right: 40px;
        }

        #document-popup-floorplan li a,
        #document-popup-floorplan li button {
            position: absolute;
            opacity: 0;
            right: 0;
            top: 2px;
            z-index: 100;
        }

        #document-popup-floorplan li:hover a,
        #document-popup-floorplan li:hover button {
            opacity: 1;
        }

        #document-popup-floorplan-preview {
            position: absolute;
            z-index: 1300;
            cursor: pointer;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        #document-popup-floorplan-preview img {
            background: #fff;
            padding: 10px;
            width: auto;
            max-width: 90%;
            height: auto;
            max-height: 90%;
        }
    </style>
[{/isys_group}]
