<div id="document-popup">
    <h3 class="popup-header">
        <img class="fr mouse-pointer popup-closer" alt="x" src="[{$dir_images}]prototip/styles/default/close.png" />
        <span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE__TEMPLATE_IMPORT_BUTTON"}]</span>
    </h3>

    <div class="popup-content">
        <div id="document-popup-template-upload-div" class="m5"></div>

        <br class="cb" />

        <hr class="mt10 mb10 hide" />

        <div id="document-popup-import-log" class="m5 hide">
            <h3 class="gradient text-shadow border p5">Log</h3>
            <ul class="list-style-none m0 mt10"></ul>
        </div>
    </div>

    <div class="popup-footer">
        <button type="button" id="document-popup-upload-and-import" class="btn mr5">
            <img src="[{$dir_images}]icons/silk/arrow_up.png" class="mr5" />
            <span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE__TEMPLATE_UPLOAD_IMPORT_BUTTON"}]</span>
        </button>

        <button type="button" id="document-popup-close" class="btn popup-closer">
            <img src="[{$dir_images}]icons/silk/cross.png" class="mr5" />
            <span>[{isys type="lang" ident="LC_UNIVERSAL__ABORT"}]</span>
        </button>
    </div>
</div>

<style type="text/css">
    #document-popup .qq-upload-list {
        width: 100%;
        margin-top: 5px;
    }

    #document-popup .qq-upload-drop-area {
        box-sizing: border-box;
        left: 0;
        top: 0;
        height: 49px;
    }

    #document-popup-import-log li {
        padding: 5px;
        border-bottom: 1px solid #ccc;
    }

    #document-popup-import-log li span {
        display: inline-block;
        width: 440px;
        text-overflow: ellipsis;
        overflow: hidden;
    }

    #document-popup-import-log li:last-of-type {
        border-bottom: none;
    }
</style>

<script type="text/javascript">
    (function () {
        "use strict";

        var $popup                = $('document-popup'),
            $upload_button        = $('document-popup-upload-and-import').disable(),
            $log_window           = $('document-popup-import-log'),
            uploaded_and_imported = false,
            uploader              = new qq.FileUploader({
                element:           $('document-popup-template-upload-div'),
                action:            '?call=document&method=upload_import_template&ajax=1',
                allowedExtensions: ['zip'],
                multiple:          false,
                autoUpload:        false,
                onSubmit:          function () {
                    $upload_button.enable()
                        .down('img').writeAttribute('src', '[{$dir_images}]icons/silk/arrow_up.png')
                        .next('span').update('[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE__TEMPLATE_UPLOAD_IMPORT_BUTTON"}]');
                },
                onCancel:          function () {
                    $upload_button.disable();
                },
                onComplete:        function (id, filename, response) {
                    var i,
                        log_types = {
                            1:  '[{$dir_images}]icons/silk/delete.png',
                            2:  '[{$dir_images}]icons/silk/delete.png',
                            4:  '[{$dir_images}]icons/silk/error.png',
                            8:  '[{$dir_images}]icons/silk/comments.png',
                            16: '[{$dir_images}]icons/silk/information.png',
                            32: '[{$dir_images}]icons/silk/bug.png'
                        },
                        $ul       = $log_window.down('ul').update();

                    if (response.success == true || response.success == 'true') {
                        uploaded_and_imported = true;

                        $upload_button
                            .down('img').writeAttribute('src', '[{$dir_images}]icons/silk/tick.png')
                            .next('span').update('[{isys type="lang" ident="LC__NOTIFY__SUCCESS"}]');

                        $('document-popup-close').down('span').update('[{isys type="lang" ident="LC__POPUP__CLOSE"}]');

                        // Display the log.
                        for (i in response.data.log) {
                            if (response.data.log.hasOwnProperty(i)) {
                                $ul
                                    .insert(new Element('li')
                                        .update(new Element('img', {className: 'vam mr5', src: log_types[response.data.log[i].level]}))
                                        .insert(new Element('span', {className: 'vam'}).update(response.data.log[i].message)));
                            }
                        }

                        $log_window.removeClassName('hide').previous('hr').removeClassName('hide');
                    } else {
                        $upload_button
                            .down('img').writeAttribute('src', '[{$dir_images}]icons/silk/cross.png')
                            .next('span').update('[{isys type="lang" ident="LC__NOTIFY__ERROR"}]');

                        idoit.Notify.error(response.message);
                    }
                },

                dragText:                          '[{isys type="lang" ident="LC_FILEBROWSER__DROP_FILE"}]',
                multipleFileDropNotAllowedMessage: '[{isys type="lang" ident="LC_FILEBROWSER__SINGLE_FILE_UPLOAD"}]',
                uploadButtonText:                  '<img src="[{$dir_images}]icons/silk/zoom.png" alt="" class="mr5 vam" /><span class="vam">[{isys type="lang" ident="LC__UNIVERSAL__FILE_ADD"}]</span>',
                cancelButtonText:                  '&nbsp;',
                failUploadText:                    '[{isys type="lang" ident="LC__UNIVERSAL__ERROR"}]',
                messages:                          {
                    typeError:    '[{isys type="lang" ident="LC_FILEBROWSER__WRONG_EXTENSION" p_bHtmlEncode=false}]',
                    noFilesError: '[{isys type="lang" ident="LC_FILEBROWSER__NO_FILE_SELECTED" p_bHtmlEncode=false}]'
                }
            });

        if ($upload_button) {
            $upload_button.on('click', function () {

                $upload_button.disable()
                    .down('img').writeAttribute('src', '[{$dir_images}]ajax-loading.gif')
                    .next('span').update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]');

                uploader.uploadStoredFiles();
            })
        }

        // Register a callback for "closing" the popup.
        $popup.on('click', '.popup-closer', function () {
            if (!uploaded_and_imported) {
                popup_close();
            } else {
                document.location.reload();
            }
        });
    })();
</script>
