<?php

/**
 * i-doit
 *
 * chapter compiler
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Selcuk Kekec <skekec@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.0
 */
class isys_document_compiler_chapter extends isys_document_compiler
{
    /**
     * Raw-Text as DOM.
     *
     * @var  DOMDocument
     */
    private $m_dom_document = null;

    /**
     * Get DOM.
     *
     * @return  DOMDocument
     */
    public function get_dom_document()
    {
        return $this->m_dom_document;
    }

    /**
     * Set DOM.
     *
     * @param   DOMDocument $p_value
     *
     * @return  isys_document_compiler_chapter
     */
    public function set_dom_document($p_value = null)
    {
        $this->m_dom_document = $p_value;

        return $this;
    }

    /**
     * Transform rawtext to DOMDocument.
     */
    public function load_dom()
    {
        $l_html = $this->get_model()
            ->get_raw_text();

        try {
            $this->m_dom_document = new DOMDocument();

            if (is_scalar($l_html) && $l_html != "" && $l_html != null) {
                // @see  DOKU-184  With the help of this string we (internally) force the DOMDocument to use UTF-8 (setting it in the constructor WILL NOT WORK).
                $this->m_dom_document->loadHTML('<meta http-equiv="Content-Type" content="text/html; charset=utf-8">' . $l_html);
            } else {
                $this->m_dom_document->loadHTML("<html><body></body></html>");
            }

        } catch (Exception $e) {
            // @see  DOKU-72  Catching possible parse errors.
            isys_application::instance()->container->get('logger')
                ->error('There is a syntax error in your HTML Chapter named "' . $this->get_model()
                        ->get_title() . '" (' . $e->getMessage() . ')', ['html' => $l_html]);
        }

        return true;
    }

    /**
     * Compile chapters and link them together
     *
     * @return $this
     * @throws isys_exception_general
     */
    protected function get()
    {
        if ($this->init()) {
            // At this point we want to refresh the existing "ref key" cache!
            isys_document_compiler_placeholder_property::reset_ref_keys();

            $l_finder = new DOMXPath($this->m_dom_document);
            
            $nodes = $l_finder->query("//*[contains(@class,'document-wysiwyg-placeholder')]");
            $i = $nodes->length - 1;

            while ($i > -1) {
                $node = $nodes->item($i);

                $l_data = json_decode(str_replace("'", '"', $node->getAttribute('data-json')), true);

                $l_placeholder_class = isys_document_compiler_placeholder::factory($l_data['type'], $l_data, $this);

                // Decode to prevent XML errors
                $l_return = $this->format($l_placeholder_class->compile());
                $l_replacer = $this->m_dom_document->createDocumentFragment();

                $l_replacer->appendXML($l_return);

                $l_root = $node->parentNode;

                $l_root->replaceChild($l_replacer, $node);

                $i--;
            }

            // Insert chapter title.
            $this->get_model()
                ->set_compiled_text($this->replace($this->m_dom_document->saveHTML()));
            $this->set_compiled(true);
        }

        return $this;
    }

    /**
     * Post-Compile.
     */
    protected function post()
    {
        ;
    }

    /**
     * Pre-Compile.
     */
    protected function pre()
    {
        ;
    }

    /**
     * Init
     */
    protected function init()
    {
        if ($this->load_dom()) {
            return true;
        }

        return false;
    }
}
