<?php

/**
 * i-doit
 * Chapter Store Model
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Selcuk Kekec <skekec@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.0
 */
class isys_document_compiler_model_chapter extends isys_document_compiler_model
{
    /**
     * Holder for parent document model
     *
     * @var  isys_document_compiler_model_document
     */
    protected $m_document = null;

    /**
     * @var  string  Chapters num in format x.x.x...
     */
    protected $m_chapter_num;

    /**
     * @var  string  HTML-Raw-Text
     */
    protected $m_raw_text;

    /**
     * @var  string  HTML-Compiled-Text
     */
    protected $m_compiled_text;

    /**
     * @var  string  HTML-Raw-Text
     */
    protected $m_level;

    /**
     * Defines if chapter shall be created in a new page or not
     *
     * @var    integer    0 or 1
     */
    protected $m_new_page;

    /**
     * Returns if chapter shall be created in a new page or not
     *
     * @return int
     */
    public function get_new_page()
    {
        return $this->m_new_page;
    }

    /**
     * Sets if chapter shall be created in a new page or not
     *
     * @param $p_value
     *
     * @return $this
     */
    public function set_new_page($p_value)
    {
        $this->m_new_page = $p_value;

        return $this;
    }

    /**
     * Returns chapters num.
     *
     * @return  string
     */
    public function get_chapter_num()
    {
        return $this->m_chapter_num;
    }

    /**
     * Set the chapter num.
     *
     * @param   string $p_chapter_num
     *
     * @return  isys_document_compiler_model_chapter
     */
    public function set_chapter_num($p_chapter_num)
    {
        $this->m_chapter_num = $p_chapter_num;

        return $this;
    }

    /**
     * Returns the HTML-Raw-Text.
     *
     * @return  string
     */
    public function get_level()
    {
        return $this->m_level;
    }

    /**
     * Set chapter level.
     *
     * @param   string $p_level
     *
     * @return  isys_document_compiler_model_chapter
     */
    public function set_level($p_level)
    {
        $this->m_level = $p_level;

        return $this;
    }

    /**
     * Returns the HTML-Compiled-Text
     *
     * @return string
     */
    public function get_compiled_text()
    {
        return $this->m_compiled_text;
    }

    /**
     * Set the HTML-Compiled-Text
     *
     * @param $p_compiled_text
     *
     * @return $this
     */
    public function set_compiled_text($p_compiled_text)
    {
        $this->m_compiled_text = $p_compiled_text;

        return $this;
    }

    /**
     * Returns the HTML-Raw-Text
     *
     * @return string
     */
    public function get_raw_text()
    {
        return $this->m_raw_text;
    }

    /**
     * Set the HTML-Raw-Text
     *
     * @param $p_raw_text
     *
     * @return $this
     */
    public function set_raw_text($p_raw_text)
    {
        // @see  DOKU-184  Removed "utf8_decode()".
        $this->m_raw_text = $p_raw_text;

        return $this;
    }

    /**
     * Get parent unit
     *
     * @return isys_document_compiler_model_document
     */
    public function get_document()
    {
        return $this->m_document;
    }

    /**
     * Set document
     *
     * @param isys_document_compiler_model_document $p_value
     *
     * @return $this
     */
    public function set_document(isys_document_compiler_model_document $p_value)
    {
        $this->m_document = $p_value;

        return $this;
    }
}