<?php

/**
 * Interface isys_document_formattable.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Dennis Stücken <dstuecken@syneticd.de>
 * @version     1.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
interface isys_document_formattable
{
    /**
     * Initialize formatter.
     *
     * @param  array $options
     *
     * @return $this
     */
    public function initialize($options);

    /**
     * Write formatted content to $p_filename.
     *
     * @param  string $filename
     *
     * @return $this
     */
    public function save($filename);

    /**
     * Send formatted content to browser.
     *
     * @param  string  $filename
     * @param  boolean $inline
     *
     * @return $this
     */
    public function send($filename, $inline);

    /**
     * Add Chapter heading.
     *
     * @param  string $title
     * @param  string $pos
     * @param  string $level
     *
     * @return $this
     */
    public function addHeadline($title, $pos, $level);

    /**
     * Add Chapter content.
     *
     * @param  string $text
     *
     * @return $this
     */
    public function addContent($text);

    /**
     * Called after exporting/formatting
     *
     * @return $this
     */
    public function afterExport();

    /**
     * Called before exporting/formatting
     *
     * @return $this
     */
    public function beforeExport();

    /**
     * Retrieves the format option definition for the current formatter.
     *
     * @return array
     */
    public function getFormatOptionDefinition();

    /**
     * Adds a new page for the chapter if defined
     *
     * @return $this
     */
    public function addNewPage();

    /**
     * Method for returning the current content.
     *
     * @return string
     */
    public function getContent();
}
