<?php

namespace idoit\Module\Document\Console\Command;

use Exception;
use idoit\Console\Command\AbstractCommand;
use isys_document_compiler_document;
use isys_document_dao;
use Symfony\Component\Console\Input\InputDefinition;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Input\InputOption;
use Symfony\Component\Console\Output\OutputInterface;

class CompileDocumentsCommand extends AbstractCommand
{
    const NAME = 'CompileDocuments';

    /**
     * Get name for command
     *
     * @return string
     */
    public function getCommandName()
    {
        return self::NAME;
    }

    /**
     * Get description for command
     *
     * @return string
     */
    public function getCommandDescription()
    {
        return '';
    }

    /**
     * Retrieve Command InputDefinition
     *
     * @return InputDefinition
     */
    public function getCommandDefinition()
    {
        $definition = new InputDefinition();

        $definition->addOption(new InputOption(
            'documentId',
            't',
            InputOption::VALUE_REQUIRED | InputOption::VALUE_IS_ARRAY,
            'Several document ids'
        ));

        return $definition;
    }

    /**
     * Checks if a command can have a config file via --config
     *
     * @return bool
     */
    public function isConfigurable()
    {
        return false;
    }

    /**
     * Returns an array of command usages
     *
     * @return string[]
     */
    public function getCommandUsages()
    {
        return [];
    }

    protected function execute(InputInterface $input, OutputInterface $output)
    {
        $l_error_count = 0;
        $l_document_ids = $input->getOption('documentId');

        $l_document_dao = new isys_document_dao($this->container->database);
        $output->writeln("Prepare update process for ".count($l_document_ids).": ");
        foreach ($l_document_ids AS $l_document_id) {
            $output->writeln("+ ----------------------------------------------------------- +");
            $l_document_res = $l_document_dao->get_data($l_document_id);

            if ($l_document_res->count()) {
                $l_document_row = $l_document_res->get_row();

                $output->writeln("Document with id ".$l_document_id." found: ".$l_document_row['isys_document_template__title']);
                $output->writeln("Refresh documents content...");

                try {
                    isys_document_compiler_document::refresh_document($l_document_id);

                    $output->writeln("Document refreshed successfully.");
                } catch(Exception $e) {
                    $l_error_count++;
                    $output->writeln("Error: ".$e->getMessage());
                }
            } else {
                $l_error_count++;
                $output->writeln("Given document id ".$l_document_id." does not exist. Skipped!");
            }
        }

        $output->writeln("+ ----------------------------------------------------------- +");
        $output->writeln('Job finished with '.$l_error_count.' error(s).');
    }
}
