<?php

namespace idoit\Module\Document\CustomFields\Entity;

use idoit\Module\Document\CustomFields\Exception\UnknownDataType;
use idoit\Module\Document\CustomFields\Value\AbstractCustomFieldValue;

class CustomField
{
    /**
     * @var int
     */
    private $id;

    /**
     * @var int
     */
    private $templateId;

    /**
     * @var string
     */
    private $name;

    /**
     * @var string
     */
    private $dataType;

    /**
     * @var AbstractCustomFieldValue
     */
    private $defaultValue;

    /**
     * @var AbstractCustomFieldValue
     */
    private $value;

    /**
     * Construct CustomField with values from database.
     *
     * @param  integer $id
     * @param  integer $templateId
     * @param  string  $name
     * @param  string  $dataType
     * @param  mixed   $defaultValue
     * @param  mixed   $value
     *
     * @throws UnknownDataType
     */
    public function __construct($id, $templateId, $name, $dataType, $defaultValue = null, $value = null)
    {
        if (!class_exists($dataType) || !is_a($dataType, AbstractCustomFieldValue::class, true)) {
            throw new UnknownDataType('You provided an unknown dataType (' . $dataType . ') which not exists and/or does not implement ' . AbstractCustomFieldValue::class);
        }

        $this->id = (int)$id;
        $this->templateId = (int)$templateId;
        $this->name = $name;
        $this->dataType = $dataType;
        $this->defaultValue = new $dataType($defaultValue);
        $this->value = new $dataType($value);
    }

    /**
     * @return int
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * @return int
     */
    public function getTemplateId()
    {
        return $this->templateId;
    }

    /**
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * @return string
     */
    public function getDataType()
    {
        return $this->dataType;
    }

    /**
     * @todo   Is this method necessary? If we have no value (only a default value) we can pass it as our 'value'?
     * @return AbstractCustomFieldValue
     */
    public function getDefaultValue()
    {
        return $this->defaultValue;
    }

    /**
     * @return AbstractCustomFieldValue
     */
    public function getValue()
    {
        return $this->value;
    }
}
