<?php

namespace idoit\Module\Document\CustomFields\Value;

use isys_application;
use isys_module_document;
use isys_smarty_plugin_f_textarea;

/**
 * i-doit customfield textarea value.
 *
 * @package     document
 * @author      Kevin Mauel <kmauel@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       1.3.0
 */
class TextareaValue extends AbstractCustomFieldValue
{
    const LABEL = 'LC__MODULE__DOCUMENT__CUSTOM_FIELDS__VALUE__TEXTAREA';

    /**
     * @inheritdoc
     */
    public function getStringValue()
    {
        return $this->value;
    }

    /**
     * @inheritdoc
     */
    public function getFormattedValue()
    {
        return nl2br($this->value, true);
    }

    /**
     * @inheritdoc
     */
    public function getTemplate($name, $value, $editMode)
    {
        $smartyPlugin = new isys_smarty_plugin_f_textarea();
        $template = isys_application::instance()->container->get('template');
        $parameters = [
            'id'         => $name,
            'name'       => $name,
            'p_strValue' => $value,
        ];

        if ($editMode) {
            return $smartyPlugin->navigation_edit($template, $parameters);
        }

        return $smartyPlugin->navigation_view($template, $parameters);
    }
}
