<div id="document-popup">
    <h3 class="popup-header">
        <img class="fr mouse-pointer popup-closer" src="[{$dir_images}]icons/close-circle.png" />
        <span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT__CREATE_DOCUMENT"}]</span>
    </h3>

    <div class="popup-content p5" style="position: absolute;top: 33px;bottom: 31px;">
        [{if count($documentTemplateData)}]
        <table class="contentTable">
            <tr>
                <td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__DOCUMENT__DOCUMENT_TEMPLATE_TITLE" name="C__DOCUMENT__TITLE"}]</td>
                <td class="value">[{isys type="f_text" name="C__DOCUMENT__TITLE"}]</td>
            </tr>
            <tr>
                <td class="key">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__DOCUMENT__DOCUMENT_TEMPLATE" name="C__DOCUMENT__TEMPLATE"}]</td>
                <td class="value">[{isys type="f_dialog"
                    name="C__DOCUMENT__TEMPLATE"
                    id="C__DOCUMENT__TEMPLATE"
                    p_arData=$documentTemplateData
                    p_arDisabled=$documentTemplateDisabledData
                    p_bInfoIconSpacer=1
                    p_strSelectedID=$documentTemplateID
                    chosen=true
                    p_bDbFieldNN=true
                    emptyMessage="LC__MODULE__DOCUMENT__DOCUMENT__TEMPLATE_NOT_FOUND"}]
                </td>
            </tr>
            [{if count($documentTemplateData)}]
            <tr>
                <td class="key"></td>
                <td class="value">
                    <p class="ml20 m10 p5 box-yellow">
                        <img src="/images/icons/silk/error.png" class="mr5 vam">
                        <span class="vam">
                                <strong>[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE__TEMPLATES_WITHOUT_CHAPTERS"}]</strong>
                            </span>
                    </p>
                </td>
            </tr>
            [{/if}]
            <tr>
                <td class="key">[{isys type="f_label" ident="LC__POPUP__BROWSER__UI_OBJ_SELECTION" name="LC__POPUP__BROWSER__UI_OBJ_SELECTION"}]</td>
                <td class="value">
                    [{if $preselection}]
                    [{isys type="f_popup" name="C__DOCUMENT__OBJECT" p_strPopupType="browser_object_ng" p_strSelectedID=$preselection catFilter="C__CATG__DOCUMENT"}]
                    [{else}]
                    [{isys type="f_popup" name="C__DOCUMENT__OBJECT" multiselection=1 p_strPopupType="browser_object_ng" catFilter="C__CATG__DOCUMENT"}]
                    [{/if}]
                </td>
            </tr>
            <tr>
                <td class="key vat">[{isys type="f_label" ident="LC__MODULE__DOCUMENT__DOCUMENT__DESCRIPTION" name="C__DOCUMENT__DESCRIPTION"}]</td>
                <td class="value">
                    [{isys
                    type="f_wysiwyg"
                    name="C__DOCUMENT__DESCRIPTION"
                    id="C__DOCUMENT__DESCRIPTION"
                    forceUsage=true
                    p_strStyle="width:250px;"}]
                </td>
            </tr>
        </table>
        [{else}]
        <div class="box-red p5">[{$noTemplatesError}]</div>
        [{/if}]
    </div>

    <div class="popup-footer">
        [{if count($documentTemplateData)}]
        <button type="button" class="btn" id="saveChapter">
            <img src="[{$dir_images}]icons/silk/add.png" class="mr5"><span>[{isys type="lang" ident="LC__CMDB__OBJECT_BROWSER__SCRIPT__ADD"}]</span>
        </button>
        [{/if}]

        <button type="button" class="btn popup-closer">
            <img src="[{$dir_images}]icons/silk/cross.png" class="mr5"><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
        </button>
    </div>
</div>

<style type="text/css">
    #document-popup td.key {
        width: 150px;
    }
</style>

<script type="text/javascript">
    (function () {
        'use strict';

        var $template    = $('C__DOCUMENT__TEMPLATE'),
            $save_button = $('saveChapter');

        $$('.popup-closer').invoke('on', 'click', function () {
            popup_close($('popup_commentary'));
        });

        if (!$template && $save_button) {
            $save_button.disable();
        }

        [{if count($documentTemplateData) > 0}]

        // Add the chosen plugins.
        $('document-popup').select('select.chosen-select').each(function (element) {
            new Chosen(element, {search_contains: true});
        });

        if ($save_button) {
            $save_button.on('click', function () {
                if ($template.getValue() > 0) {
                    $save_button
                        .down('img').writeAttribute('src', '[{$dir_images}]ajax-loading.gif')
                        .next('span').update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]');

                    new Ajax.Request('?[{$smarty.const.C__GET__MODULE_ID}]=[{$smarty.const.C__MODULE__DOCUMENT}]&ajax=1&call=document&method=createDocument', {
                        method:     'post',
                        parameters: {
                            documentTitle:      $F('C__DOCUMENT__TITLE'),
                            documentTemplateID: $template.getValue(),
                            description:        $F('C__DOCUMENT__DESCRIPTION'),
                            object:             $F('C__DOCUMENT__OBJECT__HIDDEN')
                        },
                        onComplete: function (transport) {
                            if (transport.responseText.blank()) {
                                window.location.reload(true);
                            } else {
                                $save_button
                                    .down('img').writeAttribute('src', '[{$dir_images}]icons/silk/add.png')
                                    .next('span').update('[{isys type="lang" ident="LC__CMDB__OBJECT_BROWSER__SCRIPT__ADD"}]');

                                idoit.Notify.error("[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_CREATION__ERROR_WHILE_COMPILE"}]")
                            }
                        }
                    });
                } else {
                    idoit.Notify.error('[{isys type="lang" ident="LC__MODULE__DOCUMENT__DOCUMENT_CREATION__SET_OBJECT_AND_TEMPLATE"}]');
                }
            });
        }
        [{/if}]
    })();
</script>
