<?php
/**
 * i-doit
 *
 * Dashboard widget class
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.2
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_dashboard_widgets_document_last_revisions extends isys_dashboard_widgets
{
	/**
	 * Path and Filename of the template.
	 * @var  string
	 */
	protected $m_tpl_file = '';

	/**
	 * Path and Filename of the configuration template.
	 * @var  string
	 */
	protected $m_config_tpl_file = '';


	/**
	 * Init method.
	 *
	 * @param   array  $p_config
	 * @return  isys_dashboard_widgets_quicklaunch
	 * @author  Leonard Fischer <lfischer@i-doit.com>
	 */
	public function init ($p_config = array())
	{
		$this->m_tpl_file = __DIR__ . '/templates/last_revisions.tpl';
		$this->m_config_tpl_file = __DIR__ . '/templates/config.tpl';

		return parent::init($p_config);
	} // function


	/**
	 * Render method.
	 *
	 * @param   string  $p_unique_id
	 * @return  string
	 * @author  Leonard Fischer <lfischer@i-doit.com>
	 */
	public function render ($p_unique_id)
	{
		global $g_dirs;

		/* @var  isys_cmdb_dao_category_g_document  $l_dao */
		$l_dao = isys_factory::get_instance('isys_cmdb_dao_category_g_document', isys_application::instance()->database);
		$l_quickinfo = new isys_ajax_handler_quick_info();
		$l_revisions = array();
		$l_error_message = false;

		try
		{
			$l_revision_res = $l_dao->get_last_revisons(null, C__RECORD_STATUS__NORMAL, $this->m_config['count'] ?: 10);

			if (count($l_revision_res))
			{
				while ($l_revision_row = $l_revision_res->get_row())
				{
					$l_links = isys_module_document::get_export_links($l_revision_row['isys_document__id'], $l_revision_row['isys_document_revision__id']);

					$l_revisions[] = array(
						'obj_url' => $l_quickinfo->get_quick_info(
							$l_revision_row['isys_obj__id'],
							'<img src="' . $g_dirs['images'] . 'icons/silk/link.png" class="mr5 vam" />' . _L($l_dao->get_obj_type_name_by_obj_id($l_revision_row['isys_obj__id'])) . ' &raquo; ' . $l_revision_row['isys_obj__title'],
							C__LINK__OBJECT),
						'created_datetime' => isys_application::instance()->container->locales->fmt_datetime($l_revision_row['isys_document_revision__created']),
						'html_url' => $l_links['html_download'],
						'pdf_url' => $l_links['pdf_download'],
						'pdf_inline_url' => $l_links['pdf_inline'],
						'document_template_url' => isys_helper_link::create_url(array(
							C__GET__MODULE_ID => C__MODULE__DOCUMENT,
							C__GET__SETTINGS_PAGE => isys_module_document::CL__ACTION__DOCUMENT_TEMPLATES,
							'action' => 'edit',
							C__GET__ID => $l_revision_row['isys_document_template__id'],
						)),
						'document_template_name' => $l_revision_row['isys_document_template__title']
					);
				} // while
			} // if
		}
		catch (Exception $e)
		{
			$l_error_message = $e->getMessage();
		} // try

		return $this->m_tpl
			->assign('error_message', $l_error_message)
			->assign('unique_id', $p_unique_id)
			->assign('revisions', $l_revisions)
			->fetch($this->m_tpl_file);
	} // function


	/**
	 * Returns a boolean value, if the current widget has an own configuration page.
	 *
	 * @return  boolean
	 * @author  Leonard Fischer <lfischer@i-doit.com>
	 */
	public function has_configuration ()
	{
		return true;
	} // function


	/**
	 * Method for loading the widget configuration.
	 *
	 * @param   array    $p_row  The current widget row from "isys_widgets".
	 * @param   integer  $p_id   The ID from "isys_widgets_config".
	 * @return  string
	 * @author  Leonard Fischer <lfischer@i-doit.com>
	 */
	public function load_configuration (array $p_row, $p_id)
	{
		$l_rules = array(
			'count' => $this->m_config['count']
		);

		return $this->m_tpl
			->activate_editmode()
			->assign('title', 'Reports')
			->assign('rules', $l_rules)
			->fetch($this->m_config_tpl_file);
	} // function
} // class