<?php

/**
 * @package     i-doit
 * @subpackage  Modules
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_document_format_html extends isys_document_format_text
{
    /**
     * Add Chapter heading.
     *
     * @param   string $p_title
     * @param   string $p_pos
     * @param   string $p_level
     *
     * @return  isys_document_format_html
     */
    public function addHeadline($p_title, $p_pos, $p_level)
    {
        $fontColor = '#000000';
        $fontColorKey = 'general.h' . $p_level . '.color';

        if (isset($this->m_options[$fontColorKey])) {
            $fontColor = $this->m_options[$fontColorKey];
        }

        $this->m_content .= '<h' . $p_level . ' style="color:' . $fontColor . ';">' .
            $p_pos . ' ' . $p_title .
            '</h' . $p_level . '>';

        return $this;
    }

    /**
     * Add Chapter content
     *
     * @param   string $p_text
     *
     * @return  isys_document_format_html
     */
    public function addContent($p_text)
    {
        $this->m_content .= '<div class="standard">' . str_replace(['%%CURRENT_PAGE%%', '%%TOTAL_PAGES%%'], ['', ''], $p_text) . '</div>';

        return $this;
    }

    /**
     * Retrieves the format option definition for HTML.
     *
     * @return  array
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function getFormatOptionDefinition()
    {
        return [];
    }
}
