<?php

/**
 * Class for isys_document text formats
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Dennis Stücken <dstuecken@syneticd.de>
 * @version     1.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
abstract class isys_document_format_text implements isys_document_formattable
{
    /**
     * HTML Content.
     *
     * @var  string
     */
    protected $m_content = '';

    /**
     * The format options.
     *
     * @var  array
     */
    protected $m_options = [];

    /**
     * Initialize formatter.
     *
     * @param   array $p_options
     */
    public function initialize($p_options)
    {
        $this->m_options = $p_options;
    }

    /**
     * Write formatted content to $p_filename.
     *
     * @param   string $p_filename
     *
     * @return  isys_document_format_text
     * @throws  Exception
     */
    public function save($p_filename)
    {
        if (is_writable(dirname($p_filename))) {
            file_put_contents($p_filename, $this->m_content);
        } else {
            throw new Exception('Directory ' . dirname($p_filename) . ' is not writable.');
        }

        return $this;
    }

    /**
     * Send formatted content to browser.
     *
     * @param string $p_filename
     * @param bool   $p_inline
     *
     * @return  isys_document_format_text
     */
    public function send($p_filename, $p_inline = false)
    {
        echo $this->m_content;

        return $this;
    }

    /**
     * Do nothing.
     *
     * @return  isys_document_format_text
     */
    public function afterExport()
    {
        return $this;
    }

    /**
     * Do nothing.
     *
     * @return  isys_document_format_text
     */
    public function beforeExport()
    {
        return $this;
    }

    /**
     * Adds a new page
     */
    public function addNewPage()
    {
        return $this;
    }

    /**
     * Retrieves the format option definition for HTML.
     *
     * @return  array
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function getFormatOptionDefinition()
    {
        return [];
    }

    /**
     * @inheritdoc
     */
    public function getContent()
    {
        return $this->m_content;
    }
}
