[{isys_group name="tom.popup.placeholder"}]
<div id="document-popup">
	<h3 class="popup-header">
		<img onclick="popup_close($('popup_placeholder'));" class="fr mouse-pointer" src="[{$dir_images}]icons/close-circle.png"/>
		<span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__TEMPLATE_VAR"}]</span>
	</h3>

	<div class="popup-content p10" id="document-popup-content">
		<table class="three-col w100">
			<tr>
				<td class="vat">
					<label><input type="radio" name="document-popup-template" value="current_page" /><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__TEMPLATE_VAR__CURRENT_PAGE"}]</span></label>
					<label><input type="radio" name="document-popup-template" value="total_pages" /><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__TEMPLATE_VAR__TOTAL_PAGES"}]</span></label>
					<label><input type="radio" name="document-popup-template" value="revision" /><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__TEMPLATE_VAR__REVISION"}]</span></label>
                    <label><input type="radio" name="document-popup-template" value="creation_date" /><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__TEMPLATE_VAR__REVISION_DATE"}]</span></label>
                    <label><input type="radio" name="document-popup-template" value="creation_date_time" /><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__TEMPLATE_VAR__REVISION_DATE_TIME"}]</span></label>
					<label><input type="radio" name="document-popup-template" value="revision_comment" /><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__TEMPLATE_VAR__REVISION_COMMENT"}]</span></label>
					<label><input type="radio" name="document-popup-template" value="commentary" /><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__TEMPLATE_VAR__DESCRIPTION"}]</span></label>
				</td>
				<td class="vat">
					<label><input type="radio" name="document-popup-template" value="chapter_title" /><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__TEMPLATE_VAR__CHAPTER_TITLE"}]</span></label>
					<label><input type="radio" name="document-popup-template" value="document_title" /><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__TEMPLATE_VAR__DOCUMENT_TITLE"}]</span></label>
					<label><input type="radio" name="document-popup-template" value="document_type" /><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__TEMPLATE_VAR__DOCUMENT_TYPE"}]</span></label>
					<label><input type="radio" name="document-popup-template" value="author_name" /><span>[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__TEMPLATE_VAR__AUTHOR"}]</span></label>
				</td>
                <td class="vat">
                    [{foreach $customFields as $customField}]
					<label><input type="radio" name="document-popup-template" value="custom-field-[{$customField->getId()}]" /><span>[{$customField->getName()}]</span></label>
                    [{foreachelse}]
                    <p class="text-grey">[{isys type="lang" ident="LC__MODULE__DOCUMENT__POPUP_P__TEMPLATE_VAR__NO_CUSTOM_FIELDS_YET"}]</p>
                    [{/foreach}]
                </td>
			</tr>
		</table>
	</div>

	<div class="popup-footer">
		<button type="button" class="btn" id="document-popup-save-button">
			<img src="[{$dir_images}]icons/silk/tick.png" class="mr5"><span>[{isys type="lang" ident="LC__CMDB__OBJECT_BROWSER__SCRIPT__ADD"}]</span>
		</button>
		<button type="button" class="btn popup-closer">
			<img src="[{$dir_images}]icons/silk/cross.png" class="mr5"><span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL"}]</span>
		</button>
	</div>
</div>

<style type="text/css">
	#document-popup-content label {
		display: block;
		margin-bottom: 5px;
	}

	#document-popup-content label span {
		margin-left: 5px;
	}

	#document-popup-content label * {
		vertical-align: middle;
	}
</style>

<script type="text/javascript">
	(function () {
		"use strict";

		var $popup = $('document-popup-content'),
            widget = window.currently_selected_document_widget,
			widget_data = widget.data,
            $preselection;

		// Preselect the report
		if (widget_data.hasOwnProperty('data') && widget_data.data.hasOwnProperty('key') && !widget_data.data.key.blank()) {
            $preselection = $popup.down('input[value="' + widget_data.data.key + '"]');

            if ($preselection) {
                $preselection.setValue(1);
            }
		}

		$$('.popup-closer').invoke('on', 'click', function () {
			// If the user closes the popup, we want to destroy the widget!
			if (widget.data.data && widget.data.data.hasOwnProperty('key') && widget.data.data.key.trim() === '') {
				widget.remove_and_set_focus();
			}

			popup_close($('popup_placeholder'));

			window.currentEditor.focus();
		});

		// And add some "accept" logic.
		$('document-popup-save-button').on('click', function (ev) {
			ev.preventDefault();

			var $radioselection = $popup.down('input:checked'),
				data;

			if (!$radioselection) {
			    idoit.Notify.warning('[{isys type="lang" ident="LC__BROWSER__NO_SELECTION"}]', {});

			    return;
            }

            data = {
                widget_type: 'template',
                data: {
                    key: $radioselection.getValue(),
                    name: $radioselection.next('span').innerHTML
                }
            };

			widget.setData(data);

			popup_close($('popup_placeholder'));

			window.currentEditor.focus();
		});
	})();
</script>
[{/isys_group}]
