<?php
/**
 * i-doit
 *
 * DAO: category list for the document module.
 *
 * @package     i-doit
 * @subpackage  CMDB_Category_lists
 * @author      Selcuk Kekec <skekec@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

class isys_cmdb_dao_list_catg_document extends isys_component_dao_category_table_list implements isys_cmdb_dao_list_interface
{
    /**
     * Return constant of category.
     *
     * @return  integer
     * @author  Selcuk Kekec <skekec@i-doit.org>
     */
    public function get_category()
    {
        return C__CATG__DOCUMENT;
    }

    /**
     * Return constant of category type.
     *
     * @return  integer
     * @author  Selcuk Kekec <skekec@i-doit.org>
     */
    public function get_category_type()
    {
        return C__CMDB__CATEGORY__TYPE_GLOBAL;
    }

    /**
     * Method which helps modifying each row.
     *
     * @param  array $p_row
     */
    public function modify_row(&$p_row)
    {
        global $g_dirs;

        // Format date of creation to user defined format.
        $p_row['isys_document__created'] = isys_application::instance()->container->get('locales')
            ->fmt_datetime($p_row['isys_document__created']);

        $p_row['isys_obj__title'] = '<i class="text-grey">' . _L('LC__MODULE__DOCUMENT__NO_CONNECTED_OBJECT') . '</i>';

        // Link to connected object.
        if ($p_row['isys_obj__id']) {
            $p_row['isys_obj__title'] = '<a href="' . isys_helper_link::create_url([C__CMDB__GET__OBJECT => $p_row['isys_obj__id']]) . '">' .
                '<img src="' . $g_dirs['images'] . 'icons/silk/link.png" alt="Link" class="vam" /> <span class="vam">' . $p_row['isys_obj__title'] . '</span>' .
                '</a>';
        }

        $l_module_link = isys_helper_link::create_url([
            C__GET__MODULE_ID      => C__MODULE__DOCUMENT,
            C__GET__SETTINGS_PAGE  => isys_module_document::CL__ACTION__DOCUMENT_TEMPLATES,
            'action'               => 'edit',
            'id'                   => $p_row['isys_document_template__id'],
            C__CMDB__GET__TREEMODE => C__MODULE__DOCUMENT . '00000' . $p_row['isys_document_type__id']
        ]);

        // Link to document template.
        $p_row['isys_document_template__title'] = '<a href="' . $l_module_link . '">' .
            '<img src="' . $g_dirs['images'] . 'icons/silk/link.png" class="vam mr5" /><span class="vam">' . $p_row['isys_document_template__title'] . '</span></a>';

        $l_export_links = isys_module_document::get_export_links($p_row['isys_document__id']);

        // Export-Links.
        $p_row['export_buttons'] = '<a class="btn btn-small mr5" href="' . $l_export_links['html_download'] . '">' .
            '<img src="' . $g_dirs['images'] . 'icons/silk/page_white_code.png" class="mr5"><span>' . _L('LC__MODULE__DOCUMENT__FORMAT__HTML') . '</span>' .
            '</a><a class="btn btn-small mr5" href="' . $l_export_links['pdf_download'] . '">' .
            '<img src="' . $g_dirs['images'] . 'icons/silk/page_white_acrobat.png" class="mr5"><span>' . _L('LC__MODULE__DOCUMENT__FORMAT__PDF') . '</span>' .
            '</a><a class="btn btn-small" href="' . $l_export_links['pdf_inline'] . '">' .
            '<img src="' . $g_dirs['images'] . 'icons/silk/page_white_acrobat.png" class="mr5"><span>' . _L('LC__MODULE__DOCUMENT__FORMAT__PDF') . ' ' . _L('LC__MODULE__DOCUMENT__EXPORT_INLINE') . '</span>' .
            '</a>';
    }

    /**
     * Method for retrieving the displayable fields.
     *
     * @return   array
     * @version  Niclas Potthast <npotthast@i-doit.org>
     */
    public function get_fields()
    {
        // @see  DOKU-371  Only allow to create new documents, if the user has the create right.
        $createRight = isys_module_document::getAuth()->is_allowed_to(isys_auth::CREATE, 'DOCUMENTS/' . isys_auth::EMPTY_ID_PARAM);

        // Configure new button.
        isys_component_template_navbar::getInstance()
            ->set_active($createRight, C__NAVBAR_BUTTON__NEW)
            ->set_visible(true, C__NAVBAR_BUTTON__NEW)
            ->set_visible(true, C__NAVBAR_BUTTON__EDIT)
            ->set_visible(true, C__NAVBAR_BUTTON__DELETE)
            ->set_js_onclick(
                "get_popup('document_create_document', 'editMode=1&objID=" . $_GET[C__CMDB__GET__OBJECT] . "', 1000, 450, null, 'popup_commentary')",
                C__NAVBAR_BUTTON__NEW
            );

        return [
            'isys_document__id'             => 'LC__MODULE__DOCUMENT__DOCUMENT_LIST__ID',
            'isys_document__title'          => 'LC__MODULE__DOCUMENT__POPUP_P__TEMPLATE_VAR__DOCUMENT_TITLE',
            'isys_document_template__title' => 'LC__MODULE__DOCUMENT__DOCUMENT_TEMPLATE',
            'isys_document_type__title'     => 'LC__MODULE__DOCUMENT__DOCUMENT__TYPE',
            'isys_document__created'        => 'LC__CMDB__CATG__DOCUMENT__CREATION_REFRESH_DATE',
            'export_buttons'                => 'LC__MODULE__DOCUMENT__DOCUMENT__EXPORT_AS',
        ];
    }
}
